#!/usr/bin/perl
##
# Bracket Counter v2.0
#
# By: Tyler Hutcheon
# hutcheon@iaw.on.ca
# http://www.iaw.on.ca/~hutcheon/
##)

$temp=$ENV{'QUERY_STRING'};
@pairs=split(/&/,$temp);
foreach $item(@pairs) {
	($key,$content)=split (/=/,$item,2);
	$content=~tr/+/ /;
	$content=~ s/%(..)/pack("c",hex($1))/ge;
	$in{$key}=$content;
}
  $lr = "0";
  $rr = "0";
  $lc = "0";
  $rc = "0";
  $ls = "0";
  $rs = "0";
  $q = "0";

  if ($in{'file'}) {
    open(FILE, "$in{'file'}") || &error;
    @contents = <FILE>;
    close(FILE);
    foreach $line (@contents) {
       (@letters) = split(/ */, $line);
       foreach $letter (@letters) {
          &lr;
          &rr;
          &lc;
          &rc;
          &ls;
          &rs;
          &q;
       }
    }
    print "Content-Type: text/html\n\n";
    print "<HTML><HEAD><TITLE>Brackets</TITLE></HEAD><BODY>";
    print "<H1><CENTER>Brackets</H1><HR>";
    $q3 = $q + $q2;
    print "<TABLE CELLSPACING=2 border=2 CELLPADDING=5>\n
        <TR>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\(<BR>Left Round</b></TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\)<BR>Right Round</b></TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\{<BR>Left Curly</b></TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\}<BR>Right Curly</b></TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\[<BR>Left Square</b></TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\]<BR>Right Square</b></TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#80FF80><b>\"<BR>Quotations</b></TD>\n
        </TR>\n
        <TR>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFFFF>$lr</TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFFFF>$rr</TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFFFF>$lc</TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFFFF>$rc</TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFFFF>$ls</TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFFFF>$rs</TD>\n
                <TD ALIGN=Center VALIGN=Middle BGCOLOR=#FFFF00>$q3</TD>\n
        </TR>\n
        <TR>\n";
    if ($lr eq $rr) {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=#0080FF>EVEN</TD>\n";
    } else {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=FF0000><FONT COLOR=00000><b>*** UNEVEN ***</b></FONT></TD>\n";
    }
    if ($lc eq $rc) {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=#0080FF>EVEN</TD>\n";
    } else {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=FF0000><FONT COLOR=00000><b>*** UNEVEN ***</b></FONT></TD>\n";
    }
    if ($ls eq $rs) {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=#0080FF>EVEN</TD>\n";
    } else {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=FF0000><FONT COLOR=00000><b>*** UNEVEN ***</b></FONT></TD>\n";
    }
    if ($q eq $q2) {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=#0080FF>EVEN</TD>\n";
    } else {
      print "       <TD COLSPAN=2 ALIGN=Center VALIGN=Middle BGCOLOR=FF0000><FONT COLOR=00000><b>*** UNEVEN ***</b></FONT></TD>\n";
    }
    print "        </TR>\n </TABLE></center>\n";
  $debug = 1;
  if ($lr ne $rr) {
    $liner=1;
    $pos=0;
    print "<BR><BR> Debug Listing of Round Brackets:<BR><BR>";
    foreach $line (@contents) {
       (@letters) = split(/ */, $line);
       foreach $letter (@letters) {
          &lr;
          &rr;
       }
       $liner++
    }
    print "<BR><BR>";
  }
  if ($lc ne $rc) {
    $pos=0;
    print "<BR><BR> Debug Listing of Curly Brackets:<BR><BR>";
    $liner=1;
    foreach $line (@contents) {
       (@letters) = split(/ */, $line);
       foreach $letter (@letters) {
          &lc;
          &rc;
       }
       $liner++
    }
    print "<BR><BR>";
  }
  if ($ls ne $rs) {
    $pos=0;
    print "<BR><BR> Debug Listing of Square Brackets:<BR><BR>";
    $liner=1;
    foreach $line (@contents) {
       (@letters) = split(/ */, $line);
       foreach $letter (@letters) {
          &ls;
          &rs;
       }
       $liner++
    }
    print "<BR><BR>";
  }
  if ($q ne $q2) {
    $pos=0;
    print "<BR><BR> Debug Listing of Quotes:<BR><BR>";
    $liner=1;
    foreach $line (@contents) {
       (@letters) = split(/ */, $line);
       foreach $letter (@letters) {
          &q;
       }
       $liner++
    }
    print "<BR><BR>";
  }
  print "How to read above:  The table at the top tells you the type of bracket, and how many there are, it also tells you if that number equals the number of closures of that type of bracket(or evenness of quotes). If there is a set of brackets or quotes that are uneven, there will be a debug listing for those types of brackets/quotes.  The line number is on the side, followed by the open or close of the bracket.<BR><BR></body></html>";
} else {
  print "Content-Type: text/html\n\n";
  print "<h1><Center>Brackets</h1><BR><HR><BR>Input File: <FORM><input type=text name=file><BR><input type=submit value=\"Check Brackets\"></FORM>";
  exit;
}
exit;


sub lr {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\(/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " (";
         } else {
           print "<BR>$liner:\&nbsp;";
           print "\&nbsp;" x $pos;
           print "(";
         }
         $lastline = $liner;
         $pos++;
         $pos++;
       } else {
         $lr = $lr + 1;
       }
     }
}
sub rr {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\)/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " )";
         } else {
           print "<BR>$liner:\&nbsp;";
           print "\&nbsp;" x $pos;
           print ")";
         }
         $lastline = $liner;
         $pos--;
         $pos--;
       } else {
         $rr++;
       }
     }
}
sub lc {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\{/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " {";
         } else {
           print "<BR>$liner:\&nbsp;";
           print "\&nbsp;" x $pos;
           print "{";
         }
         $pos++;
         $pos++;
         $lastline = $liner;
       } else {
         $lc = $lc + 1;
       }
     }
}
sub rc {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\}/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " }";
         } else {
           print "<BR>$liner:\&nbsp;";
           print "\&nbsp;" x $pos;
           print "}";
         }
         $lastline = $liner;
         $pos--;
         $pos--;
       } else {
         $rc = $rc + 1;
       }
     }
}
sub ls {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\[/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " [";
         } else {
           print "<BR>$liner:\&nbsp;";
           print "\&nbsp;" x $pos;
           print "[";
         }
         $lastline = $liner;
         $pos++;
         $pos++;
       } else {
         $ls = $ls + 1;
       }
     }
}
sub rs {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\]/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " ]";
         } else {
           print "<BR>$liner:\&nbsp;";
           print "\&nbsp;" x $pos;
           print "]";
         }
         $lastline = $liner;
         $pos--;
         $pos--;
       } else {
         $rs = $rs + 1;
       }
     }
}
sub q {
   $liner_length = length($liner);
   for ($i = 3;$i > $liner_length;$i--) {$liner = "0$liner";}
     if ($letter =~ /\"/) {
       if ($debug == 1) {
         if ($lastline eq $liner) {
           print " \"";
         } else {
           print "<BR>$liner: \"";
         }
         $lastline = $liner;
       } else {
         if ($flipflop eq 1) {
           $q = $q + 1;
           $flipflop = 0;
         } else {
           $q2 = $q2 + 1;
           $flipflop = 1;
         }
       }
     }
}
sub error {
print "Content-Type: text/html\n\n";
print "<h1><center>Brackets</H1><hr>ERROR: NON-EXISTANT FILE!!!<BR><BR><b>$in{'file'}</b><BR><BR>-GO BACK AND TRY AGAIN...";
exit;
}