#!/usr/local/bin/perl
# htaccess password protector
# Copyright 1998 Techno Trade Online Solutions http://www.technotrade.com
# Written By : Sammy Afifi   sammy@technotrade.com
# Date Last Modified : May 22, 1998
########################################################################
#
########################################################################
#
# You need to modify $formloc, $basedir, $correctpass, $emailfrom
# Be sure to upload the script in ASCII mode
# The very first line of the script points to where perl is installed on your server
# 

  #
  # URL where the script is located
  #
  $formloc = "http://www.technotrade.com/htaccess/admin.cgi";

  # The base directory is the directory one level up from where you will be securing
  # the sub-directories.
  # if you want to secure /home/user/members then the base directory will be /home/user/
  #
  #
  # Physical drive path to the script
  # Don't forget the / at the end
  #
  $basedir = "/u/web/tech12/htaccess/";
  
  #  use http://www.technotrade.com/crypt.cgi?password  for new one
  #  example http://technotrade.com/crypt.cgi?camel
  #  Then copy and paste the encrypted results below ...
  #
  $correctpass = "aaqPiZY5xR5l.";  # password is test

  # no need to change .. but you can use any file name for storing passwords
  #
  # On some servers, you may need to upload a blank .htpasswd file into the directory
  # you are protecting and chmod it to 777
  #
  $htpasswdname = ".htpasswd";
  
  $scrollsize = 10;                    # how big the user list menu will be
  $mailprog = '/usr/lib/sendmail';     # where sendmail is on your server

  # when e-mails are sent out, what will show in the From field
  # Don't forget the \ before the @ in the e-mail address
  #
  $emailfrom = "sammy\@technotrade.com (Techno Trade)"; 

  # Subject of the e-mails
  #
  $emailsubject = "Your Access Account";

  $emailtop = "Text to be placed at the top of the e-mail \n\n";
  $emailbottom = "\n\nText to be placed at the bottom of the e-mail \n\n";

  &parse_form;

  # only here for demo
  #$FORM{'targetdir'} = "secure";

  # strip funny characters off
  # this prevents you from typing in /directory/directory2 in the script
  # if you do want to be able to protect sub-sub directories then put a #
  # infront of each of the targetdir lines
  #
  $FORM{'targetdir'} =~ s/\\//g;
  $FORM{'targetdir'} =~ s/\///g;
  $FORM{'targetdir'} =~ s/\|//g;
  $FORM{'targetdir'} =~ s/\;//g;


  # do not change
  $htpasswdloc = "$basedir$FORM{'targetdir'}/$htpasswdname";

  print "Content-type: text/html\n\n";
  #
  # Check if only the admin can use
  #
  if (crypt($FORM{'password'},"aa") ne $correctpass) {
    &askforpass;
    exit;
  }

  print "<HTML><TITLE>Techno Trade's Password Editor</TITLE><BODY BGCOLOR=#FFFFFF>\n";


  if ($FORM{'targetdir'} eq "") {
    &refresh;
    exit;
  }
  &adduser if (($FORM{'action'} eq "ADD") && ($FORM{'targetdir'} ne ""));
  &deleteuser if (($FORM{'action'} eq "DELETE") && ($FORM{'targetdir'} ne ""));
  &generatehtaccess if (($FORM{'action'} eq "GEN") && ($FORM{'targetdir'} ne ""));
  &extractemails if (($FORM{'action'} eq "EMAILS") && ($FORM{'targetdir'} ne ""));

  &addinfo;

  &listusers;

  &print_end;

  exit;

#########################################
sub addinfo {

print<<ADDINFO;
  <FONT SIZE=5 COLOR=000080 FACE="VERDANA, ARIAL, HELVETICA"><B>Password editor</B></FONT><BR><BR>
  <FONT SIZE=4 COLOR=000080 FACE="VERDANA, ARIAL, HELVETICA"><B>Add User</B></FONT>
  <PRE><FORM METHOD=POST ACTION="$formloc">
  username  : <INPUT NAME="username" SIZE=20> password  : <INPUT TYPE=password SIZE=20 name="pass">
  name      : <INPUT SIZE=20 name="name"> email     : <INPUT SIZE=30 name="email">
  comments  : <INPUT SIZE=30 name="comments">
  <INPUT TYPE="CHECKBOX" NAME="sendemail" VALUE="Y">       : Check to e-mail new entry to user
  Extra E-mail Text : 
              <TEXTAREA NAME="extratext" COLS=50 ROWS=4></TEXTAREA>
  </PRE>
  <INPUT TYPE="hidden" NAME="password" VALUE="$FORM{'password'}">
  <INPUT TYPE="hidden" NAME="targetdir" VALUE="$FORM{'targetdir'}">
  
  <INPUT TYPE="submit" Value="Add User">
  <INPUT TYPE="hidden" NAME="action" VALUE="ADD">

  </FORM>
ADDINFO

}


####################################
#
# Print Footer Info
#
sub print_end {
 &refresh;
print<<RELO1;
 <HR noshade>
 <FONT SIZE=4 COLOR=000080 FACE="VERDANA, ARIAL, HELVETICA">
 <B>Generate .htaccess file</B></FONT>
 <FORM METHOD="POST" ACTION="$formloc">
 <PRE><INPUT TYPE="hidden" NAME="password" VALUE="$FORM{'password'}">
 Directory : <INPUT NAME="targetdir" VALUE="$FORM{'targetdir'}">
 </PRE>
 <INPUT TYPE="hidden" NAME="action" VALUE="GEN">
 <INPUT TYPE="submit" Value=" Generate ">
 </FORM>
 <BR>
 This will display what your .htaccess file should look like for the above directory<BR>
 Just copy and paste the results of this to a text editor, save the file as .htaccess and
 upload to the directory you wish to password protect. (Use your browser's back button to return) 
 <HR noshade>
 <FONT SIZE=4 COLOR=000080 FACE="VERDANA, ARIAL, HELVETICA">
 <B>Extract E-mails</B></FONT>
 <FORM METHOD="POST" ACTION="$formloc">
 <INPUT TYPE="hidden" NAME="password" VALUE="$FORM{'password'}">
 <INPUT TYPE=HIDDEN NAME="targetdir" VALUE="$FORM{'targetdir'}">

 <INPUT TYPE="hidden" NAME="action" VALUE="EMAILS">
 <INPUT TYPE=CHECKBOX NAME="comma" VALUE="Y"> Add a comma after each line ?<BR>
 <INPUT TYPE="submit" Value=" Extract E-mails "><BR><BR>
 This feature is used to pull all the e-mail address from your member list.
 You can then copy and paste the list to your favorite e-mail program.
 </FORM>
 <BR>


RELO1

  print "<BR><CENTER><A HREF=\"http://www.technotrade.com\">Techno Trade Online Solutions</A> \&nbsp;\&nbsp;\&nbsp; <A HREF=\"http://www.technotrade.com/htaccess/\">Script Home</A><BR>\n";
  print "</CENTER>\n";
  print "</BODY></HTML>\n";
}

############
sub refresh {
 print<<REFRE1;
 <HR noshade>
 <FONT SIZE=4 COLOR=000080 FACE="VERDANA, ARIAL, HELVETICA">
 <B>Refresh Screen</B></FONT><BR>
 Change to a directory which you want password protected<BR> 
 <FORM METHOD="POST" ACTION="$formloc">
 <PRE><INPUT TYPE="hidden" NAME="password" VALUE="$FORM{'password'}">
 Directory : <INPUT NAME="targetdir" VALUE="$FORM{'targetdir'}">
 </PRE>
 <INPUT TYPE="submit" Value=" Refresh ">
 </FORM>
REFRE1
}

############
sub askforpass {
 print<<REFRE1;
 <HR noshade>
 <FONT SIZE=4 COLOR=000080 FACE="VERDANA, ARIAL, HELVETICA">
 <B>Enter your password/directory</B></FONT><BR>
 <FORM METHOD="POST" ACTION="$formloc">
 <PRE>
 Password  : <INPUT NAME="password" SIZE=20>
 Directory : <INPUT NAME="targetdir" SIZE=30>
 </PRE>
 <INPUT TYPE="submit" Value=" Refresh ">
 </FORM>
REFRE1
}


#####################################
#
# Prints the bottom box showing path and .htaccess format
#
sub generatehtaccess {


  print "<PRE>";
  print "AuthName Protected-Directory\n";
  print "AuthType Basic\n";
  print "AuthUserFile $basedir$FORM{'targetdir'}/$htpasswdname\n";
  print "&lt;limit GET POST>\n";
  print "require valid-user\n";
  print "&lt;/limit>\n";
  print "</PRE>\n";  

  exit;
}

###########################################
#
#  List users
#
sub listusers {

  local($user,$counter,$x);
  if (!(-e $htpasswdloc)) {
    $counter = 0;
    return;
  }
 
  print "<HR noshade><FONT SIZE=4 COLOR=000080 FACE=\"VERDANA, ARIAL, HELVETICA\"><B>List Users</B></FONT><BR><BR>\n";
  print "<FORM METHOD=\"POST\" ACTION=\"$formloc\">\n";

  open(FILE,$htpasswdloc);
  flock(FILE,2);
  @USERS = <FILE>;
  close(FILE);

  foreach $us (@USERS) {
    if (substr($us,0,1) ne "#") {
      ($user,$pass) = split (":",$us,2);
      push(@USERLIST,$user);
    } else {
      $commentline = substr($us,1);
      ($user,$name,$email,$comments,$extra) = split(/\s*\|\s*/,$commentline,5);
      $USERINFO{$user} = $commentline;
    }
  }

  #
  # Sort by username
  #
  @USERLIST = sort {$a cmp $b} @USERLIST;

  print "<SELECT NAME=\"username\" SIZE=$scrollsize>\n";

  foreach $user (@USERLIST) {
    print "<OPTION VALUE=\"$user\">$user";
    if ($USERINFO{$user}) {
       ($user,$name,$email,$comments,$extra) = split(/\s*\|\s*/,$USERINFO{$user},5);
       print " - $name - $email - $comments\n";
    }
  }
print<<LU1;
</SELECT>
<INPUT TYPE="hidden" NAME="action" VALUE="DELETE">
<INPUT TYPE="hidden" NAME="password" VALUE="$FORM{'password'}">
<INPUT TYPE="HIDDEN" NAME="targetdir" VALUE="$FORM{'targetdir'}">
<BR>
<INPUT TYPE=\"submit\" Value=\"Delete User (Select one from list)\">
<BR><BR>
Or Select a User to modify password<BR>
New Password : <INPUT TYPE=PASSWORD NAME="newpass" SIZE=20><BR>
<INPUT TYPE="CHECKBOX" NAME="sendemail" VALUE="Y">       : Check to e-mail modification to user
<BR>
<INPUT NAME="modbutton" TYPE=\"submit\" Value=\"Modify Password">
</FORM>
LU1
}

###########################################
#
#  Extract E-mails
#
sub extractemails {

  local($user,$counter,$x);
  if (!(-e $htpasswdloc)) {
    $counter = 0;
    return;
  }
 
  open(FILE,$htpasswdloc);
  flock(FILE,2);
  @USERS = <FILE>;
  close(FILE);
  print "Extracting E-mails ... <BR><BR>";
  foreach $us (@USERS) {
    if (substr($us,0,1) eq "#") {
      $commentline = substr($us,1);
      ($user,$name,$email,$comments,$extra) = split(/\s*\|\s*/,$commentline,5);
      if ($email =~ /\@/) {
         print "$email";
         print "," if ($FORM{'comma'} eq "Y");
         print "<BR>\n";
      }
    }
  }
  exit;
}


###################################################
#
# Delete User
#
sub deleteuser {

  open(FILE,$htpasswdloc);
  flock(FILE,2);
  @USERS = <FILE>;
  close(FILE);

  open(FILE,">$htpasswdloc");
  flock(FILE,2);
  $counter = @USERS;
  for ($x=0; $x < $counter; $x++) {
    if (substr($USERS[$x],0,1) ne "#") {
      ($user,$pass) = split (":",$USERS[$x],2);
    } else {
      $commentline = substr($USERS[$x],1);
      $commentline =~ s/\n//g;
      ($user,$name,$email,$comments,$extra) = split(/\s*\|\s*/,$commentline,5);
      if ($FORM{'username'} eq $user) {
        $deluser = $user;
        $delname = $name;
        $delemail = $email;
        $delcomments = $comments;
        $delextra = $extra;
      }
    }
    print FILE "$USERS[$x]" if ($user ne $FORM{'username'});
  }

  if (($FORM{'username'} ne "") && ($FORM{'modbutton'} eq "Modify Password") && ($FORM{'newpass'} ne "")) {
    print FILE
    join (":", $deluser, crypt($FORM{'newpass'},"aa")), "\n";
    print FILE "#$deluser|$delname|$delemail|$delcomments|$extra\n";
    if (($FORM{'sendemail'} eq "Y") && ($delemail =~ /\@/)) {
       &send_email($delemail,$deluser,$FORM{'newpass'},"");
    }
  }
  close(FILE);

}

#################################################
#
# Add user to the file
#
sub adduser {

  $FORM{'pass'} =~ s/\n//g;
  $FORM{'email'} =~ s/\n//g;
  $FORM{'name'} =~ s/\n//g;
  $FORM{'comments'} =~ s/\n//g;
  $FORM{'pass'} =~ s/\|//g;
  $FORM{'email'} =~ s/\|//g;
  $FORM{'name'} =~ s/\|//g;
  $FORM{'comments'} =~ s/\|//g;

  
  &endscript("Username must be lowercase alphabetic + numeric!")
    unless $FORM{'username'} =~ /^[a-z,0-9]+$/;

  &endscript("Your must enter a password!")
    unless $FORM{'pass'} =~ /\S/;


  open (PW, "+>>$htpasswdloc") ||
  &endscript("Cannot Locate $htpasswdloc: $!");
  flock (PW, 2);			
  seek (PW, 0, 0);
  while (<PW>) {
    my ($user) = split ":";
    &endscript("sorry, that username is already taken") if $user eq $FORM{'username'};
  }

  seek (PW, 0, 2);		# end of file
  $password = $FORM{'pass'};
  print PW
  join (":", $FORM{'username'}, crypt($password,"aa")), "\n";
  print PW "#$FORM{'username'}|$FORM{'name'}|$FORM{'email'}|$FORM{'comments'}|0\n";
  close PW;
  
  if (($FORM{'sendemail'} eq "Y") && ($FORM{'email'} =~ /\@/)) {
     &send_email($FORM{'email'},$FORM{'username'},$FORM{'pass'},$FORM{'extratext'});
  }

}
####################################################
sub send_email {
  local($uemail,$uname,$upass,$extratext) = @_;

  open(MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";
  print MAIL "To: $uemail\n";
  print MAIL "From: $emailfrom\n";
  print MAIL "Subject: $emailsubject\n\n";
  print MAIL "$emailtop";
  print MAIL " Username : $uname\n";
  print MAIL " Password : $upass\n\n";
  print MAIL "$extratext\n";
  print MAIL "$emailbottom";
  close(MAIL);
}

####################################################
sub endscript {
  local ($str) = @_;

  print " $str <BR> \n";
  exit;

}

#####################################################
#
# Parse Form Data
#
sub parse_form {

   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
   if (length($buffer) < 5) {
         $buffer = $ENV{QUERY_STRING};
    }
   @pairs = split(/&/, $buffer);
   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $FORM{$name} = $value;
   }
}

