# ==============================================================
#               -------------
#                  MysqlMan
#               -------------
#				   html.pl
#
#          Web: http://www.gossamer-threads.com/
#      Support: support@gossamer-threads.com
#
# COPYRIGHT NOTICE:
#
# Copyright 2000 Gossamer Threads Inc.  All Rights Reserved.
#
# By using this program you agree to indemnify Gossamer Threads 
# Inc. from any liability.
#
# Please see the README for full license details.
# ==============================================================
#
# Html.pl uses both GT_Base.pl and GT_Template to substitude variables
# in the templates with real values.  Variables in the templates are in
# the form <%variable_name%>.  For more detailed usage of GT_Templates 
# please refer to the bottom of GT_Templates.pm.
#
#
# Common Variables
# --------------------------------------------------------
# home_url   : the URL to home page.  (Specified in mysql.cfg)
# script_url : the URL to mysql.cgi.  (Specified in mysql.cfg)
# db         : the name of current database.
# table      : the name of current table.
#



sub html_database{
# --------------------------------------------------------
# List of databases in MySQL.
#     db_table : the table that contain the databases in MySQL 
#                together with "drop" links to drop databases.
#     $feedback: feedback message of any action performed before 
#                arriving the page.

	my ($in, $data_source, $db_table, $feedback) = @_;
	print GT_Template->parse ($config{'template_dir'} . '/database.html', { 
									do			=> $in->param('do') || '',
									home_url	=> $config{'home_url'} || '', 
									script_url	=> $config{'script_url'}, 
									db_table	=> $db_table || '',
									data_source => $in->escapeHTML($data_source) || '',
									table		=> '',
									feedback	=> $in->escapeHTML($feedback),
									});
}

sub html_table{
# --------------------------------------------------------
# List of tables in the database selected.
#     table_tables: the table that contains the table names in 
#                   the database together with action links
#                   (browse/select/property/insert/empty/drop)
#     $feedback   : feedback message of any action performed before 
#                   arriving the page.   

	my ($in, $table_tables, $feedback) = @_;
	print GT_Template->parse ($config{'template_dir'} . '/table.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')),
									table_tables	=> $table_tables || '',
									table			=> '',
									from_monitor	=> $in->param('from_monitor') || '',
									feedback		=> $in->escapeHTML($feedback),
									});
}

sub html_table_browse{
# --------------------------------------------------------
# This will display the result of any query that requires records to 
# be displayed.
#     page         : the current page.
#     page_jump    : the input box that allows the user to go to any page.
#     page_link    : the links to prev/next/top page.
#     col_name     : the column names in the table.
#     table_records: the table that contains the result of the query.
#     query_printed: the query executed.
#     total_rows   : total number of rows resulted from the query.
#     
 	my ($in, $table, $page_jump, $page_link, $col_name, $table_records, $query, $empty_set, 
		$pri_key, $query_printed, $total_rec_num) = @_;

	print GT_Template->parse ($config{'template_dir'} . '/table_browse.html', {
									total_rows		=> $total_rec_num || '',
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $table || '',
									page			=> $in->param('page') || '1',
									empty_set		=> $empty_set || '',
									page_jump		=> $page_jump || '',
									page_link		=> $page_link || '',
									col_name		=> $col_name || '',
									table_records	=> $table_records || '',
									query			=> $in->escapeHTML($query) || '',
									query_printed	=> $query_printed || $query || '', 
									action			=> $in->param('browse_action') || $in->param('action') || '',
									pri_key			=> $pri_key || '',
									from_monitor	=> $in->param('from_monitor') || '',
									});
}

sub html_table_select{
# --------------------------------------------------------
# Search page that allows the user to compose a SELECT query.
#     select_table : the fields that are available for the SELECT query.
#     example_table: table input fields that lets the user to construct a 
#                    query to "query by example."

	my ($in, $select_table, $example_table) = @_;
	print GT_Template->parse ($config{'template_dir'} . '/table_select.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									select_table	=> $select_table,
									example_table	=> $example_table,
									});
}

sub html_property{
# --------------------------------------------------------
# Displays the specificaions of a table. 
#     $table_property: the table that consists of the table spec's
#                      and action links (change/drop/primary/index/unique).
#     key_table      : the table that shows the keys in the table.
#     $feedback      : feedback message of any action performed before 
#                      arriving the page.
     

	my ($in, $table_property, $feedback) = @_;
	print GT_Template->parse ($config{'template_dir'} . '/property.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) ||'',
									table			=> $in->param('table') || '',
									table_property	=> $table_property || '',
									key_table		=> &get_key_table($in) || '',
									feedback		=> $in->escapeHTML($feedback) || '',
									});
}

sub html_insert{
# --------------------------------------------------------
# Insert new record.
#     $form_fields: the input table that lets the user to enter
#                   values in to create a new record.
#     $feedback   : feedback message of any action performed before 
#                   arriving the page.

	my ($in, $feedback) = @_;

	my $table = $in->param('table');
	my $form_fields = &form_fields($in, 0, ()) or return undef;
	if ($config{'demo_mode'}) { &alias_name_check($table, $in); }

	print GT_Template->parse ($config{'template_dir'} . '/insert.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source'))|| '',
									table			=> $in->param('table') || '',
									insert_fields	=> $form_fields,
									feedback		=> $in->escapeHTML($feedback) || '',
									});
}

sub html_update{
# --------------------------------------------------------
# Edit record page.
#     $insert_fields: the input table with original values of the record 
#                     in the input fields.

	my ($in, $insert_fields) = @_;
	print GT_Template->parse ($config{'template_dir'} . '/edit.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									insert_fields	=> $insert_fields,
									record_modify	=> $in->escapeHTML($in->param('record_modify')) || '',
									page			=> $in->param('page') || 1,
									action			=> $in->param('action') || '',
									sort_index		=> $in->escapeHTML($in->param('sort_index')) || '',
									fields			=> $in->escapeHTML($in->param('fields')) || '',
									where			=> $in->escapeHTML($in->param('where')) || '', 
									example			=> $in->escapeHTML($in->param('example')) || '',
									browse_action	=> $in->param('browse_action') || '',
									});
}

sub html_table_def{
# --------------------------------------------------------
# lets the user to construct the specificaitons of fields/columns. 
# Used when creating a new table or adding new field(s)/column(s).
# If a new table is to be created, the table name is first checked to 
# see if it is a valid one.  Then the number of fields/columns is checked
# also for its validity.
#     $columns: the input table that lets user to construct field/column
#               spec's.        
#

	my ($in, $action) = @_;
	my ($columns);

	if ($action eq 'create') { $do = 'create_table'; }
	else { $do = 'alter_table'; }

	&valid_name_check($in->param('table')) or return undef;

	if ($in->param('num_of_fields') < 1)	{ &sqlerr("Number of fields cannot be less than 0.") }
	elsif ($in->param('num_of_fields')>500)	{&sqlerr("Number of fields too large.") }	 
	else {
		for (my $i = 0; $i < $in->param('num_of_fields'); $i++) {
			$columns .= GT_Template->parse ($config{'template_dir'} . '/create_field.txt', { field_num => $i });	
		}

		print GT_Template->parse ($config{'template_dir'} . '/create_table.html', { 
									do				=> $do,
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									columns			=> $columns,
									num_of_fields	=> $in->param('num_of_fields') || '',
									});
	}
}

sub html_alter_col{
# --------------------------------------------------------
# Change field/column specification.
#     col    : the field/column name that's being changed.
#     field  : same as col.
#     type   : the original field/column type.
#     null   : either 'YES' or ''.
#     default: the default value.
#     extra  : extra properties. (auto_increment)

	my ($in, $field, $type, $length_set, $attributes, $null, $default, $extra) = @_;
	my ($type_select, $null_select, $extra_select);

# show the original field/column specs.	
	$type_select = "<option>$type</option>";

	if ($attributes) { $attribute_select = "<option>$attributes</option>"}

	if ($null) { $null_select = '<option>null</option>' }
	else { $null_select = '<option>not null</option>' }

	if ($extra) {$extra_select = "<option>$extra</option>"}	

	print GT_Template->parse ($config{'template_dir'} . '/alter_col.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									col				=> $in->param('col') || '',
									field			=> $field, 
									type			=> $type,
									length_set		=> $in->escapeHTML($length_set),
									attributes		=> $attributes,
									null			=> $null, 
									default			=> $default, 
									extra			=> $extra,
									type_select		=> $type_select,
									null_select		=> $null_select,
									extra_select	=> $extra_select,
								   attribute_select => $attribute_select,
									});
}

sub html_page_jump{
# --------------------------------------------------------
# displays a text input box that allow user to go to 
# any page of the result table.  
#     pages: total number of pages of the result.

	my ($in, $pages, $fields, $example, $index) = @_;
	return GT_Template->parse ($config{'template_dir'} . '/page_jump.txt', {
									do				=> $in->param('do') || '',
									script_url		=> $config{'script_url'}, 
									data_source		=> $in->param('data_source') || '',
									table			=> $in->param('table') || '',
									pages			=> $pages,
									fields			=> $fields || '',
									where			=> $in->param('where') || '',
									action			=> $in->param('action') || '',
									sort_index		=> $index || '',
									example			=> $in->escapeHTML($example) || '',
									query			=> $in->escapeHTML($in->param('query')) || '',
									});
}

sub html_confirm_action{
# --------------------------------------------------------
# Confirmation page.  
#     $query: the actual query that is going to be executed.

	my ($in, $query) = @_;

	print GT_Template->parse ($config{'template_dir'} . '/confirm.html', { 
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									do				=> $in->param('do') || '',
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									action			=> $in->param('action') || '',
									query			=> $query,
									query_param		=> $in->escapeHTML($query),
									col				=> $in->param('col') || '',
									key_name		=> $in->param('key_name') || '',
									redirect_url	=> $in->escapeHTML( $in->cookie($config{'url_cookie_name'}) ) || $config{'script_url'} || '',
									});			
}


sub html_sqlerr{
# --------------------------------------------------------
# Error message.
#     error: the actual error message.

	my ($in, $error) = @_;
	my $table = $in->param('table');
	if (($in->param('do') eq 'create') || $in->param('action') eq 'rename_table') { $table = ''; }

	print GT_Template->parse ($config{'template_dir'} . '/sqlerr.html', { 
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $table,
									error			=> $error,
									});
}

sub html_login{
# --------------------------------------------------------
# Login page.  The URL of the previous page is read in from cookie 
# or the script URL is used if the cookie is not set.  
#     url    : the URL to the previous page.
#     user   : Username.  Read from cookie.
#     pass   : Password.  Read from cookie.
#     host   : Host name.  Used for database connection and is read from cookie.
#     message: message displayed in the login page.

	my ($in, $message, $init_login) = @_;
	my $url = $in->escapeHTML( $in->cookie($config{'url_cookie_name'}) ) || $config{'script_url'} || '';
	$url =~ s/\;/&/g;

	print GT_Template->parse ($config{'template_dir'} . '/login.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									url				=> $url,
									user			=> $in->cookie($config{'db_user_cookie_name'}) || '',
									pass			=> $in->cookie($config{'db_pass_cookie_name'}) || '',
									host			=> $in->cookie($config{'db_host_cookie_name'}) || '',
									message			=> $in->escapeHTML($message) || '',
									init_login		=> $init_login || '',
									});
}

sub html_logout{
# --------------------------------------------------------
# Logout message.

	print GT_Template->parse ($config{'template_dir'} . '/logout.html', {
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> '',
									table			=> '',
									});
}

sub html_back{
# --------------------------------------------------------
# The confirmation page that is displayed after login.
#     url: the URL to the page before the login command is performed.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/login_back.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									url				=> $in->param('url') || '',
									});
}

#=================================================#
#             Top Level Operations                #
#=================================================#

sub html_create_db{
# --------------------------------------------------------
# Create new database.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/op_create_db.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									});
}
sub html_sql_monitor{
# --------------------------------------------------------
# SQL monitor.
#     $message: the feedback message from SQL monitor 
#               in the form "num_rows rows affacted"

	my ($in, $message) = @_;
	print GT_Template->parse ($config{'template_dir'} . '/op_sql_monitor.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									feedback		=> $message || '',
									});
}
sub html_create_table{
# --------------------------------------------------------
# Create new table page.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/op_create_table.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									table			=> '',
									db				=> &get_db($in->param('data_source')) || '',
									});
}
sub html_import{
# --------------------------------------------------------
# Data import page.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/op_import.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									});

}
sub html_export{
# --------------------------------------------------------
# Data export page.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/op_export.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									});

}
sub html_add_fields{
# --------------------------------------------------------
# Add field/column to table page.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/op_add_fields.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									});
}
sub html_rename_table{
# --------------------------------------------------------
# Rename table page.

	my $in = shift;
	print GT_Template->parse ($config{'template_dir'} . '/op_rename_table.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									});
}

#=================================================#
#		           Demo Prompt                    #
#=================================================#

sub html_demo_prompt{
# --------------------------------------------------------
# Demo message.  It is displayed when demo mode is on and the action performed 
# is disabled.
#
#     demo_message: message specified depending on action performed.


	my ($in, $demo_message) = @_;	
	print GT_Template->parse ($config{'template_dir'} . '/demo_prompt.html', {
									do				=> $in->param('do') || '',
									home_url		=> $config{'home_url'} || '',
									script_url		=> $config{'script_url'},
									data_source		=> $in->param('data_source') || '',
									db				=> &get_db($in->param('data_source')) || '',
									table			=> $in->param('table') || '',
									demo_message	=> $demo_message || '',
									});
	return undef;
}
1;

