#!/usr/bin/perl
#
# NOTE: CHANGES ARE NOT NECESSARY IN THIS FILE, ALL SETTINGS ARE
#       MADE IN NEWSADMIN_SETTINGS.PL
#
# NewsAdmin
#
# Copyright (c) Stefan Pettersson 1999-2000
#
# You may not redistribute this script, but it's free to use. 
#
# Version History:
#    v1.0 2000-01-06 - Added customizable dateformat, fixed small news count bug
#    v0.4 1999-12-29 - Added use of multiple passwords, linefeed to html
#                      converting and remade template-tag reparsing a bit.
#    v0.3 1999-12-05 - Error messages added
#    v0.2 1999-12-01 - Fixed path on form
#    v0.1 1999-11-29 - Initial beta version.
#
# For further information see:
#    http://www.stefan-pettersson.nu/scripts/newsadmin/
#
##############################################################################

$VERSION = "1.0";

require 'newsadmin_settings.pl';

&ReadParse;
&CookieParse;

if ($in{'action'} eq 'post') {
	if (($in{'author'} ne '') && ($in{'headline'} ne '') && ($in{'text'} ne '') && ($in{'email'} ne '') && &CheckPassword) {
		if ($in{'preview'}) {
			&PreviewNews;
		} else {
			&WriteNews;
			&PrintPostedPage;
		}
	} else {
		&VerifyFailed;
	}
} else {
	&PrintInputPage;
}

exit;

##############################################################################

sub PreviewNews {

print "Content-type: text/html\n\n";

&PrintHead;

print &ParseNewsTemplate(0, $in{'headline'}, &GetDateString, $in{'author'}, $in{'email'}, $in{'text'});

print "<p><b>Press the back button in your browser to get back.</b>";

&PrintFoot;

}

##############################################################################

sub WriteNews {
	my $unique_id = time();

	print "Set-Cookie: $ENV{'SCRIPT_NAME'}_AUTHOR=$in{'author'}; path=/; expires=Tue, 04-Oct-2061 12:00:00 GMT;\n";
	print "Set-Cookie: $ENV{'SCRIPT_NAME'}_EMAIL=$in{'email'}; path=/; expires=Tue, 04-Oct-2061 12:00:00 GMT;\n";

	my $newsitem = &ParseNewsTemplate    ($unique_id, $in{'headline'}, &GetDateString, $in{'author'}, $in{'email'}, $in{'text'});
	my $headline = &ParseHeadlineTemplate($unique_id, $in{'headline'}, &GetDateString, $in{'author'}, $in{'email'}, $in{'text'});
	
	&WriteNewsItem($newsitem);
	&WriteHeadlines($headline);
}

##############################################################################

sub WriteNewsItem {
	my $newsitem = $_[0];
	my $i = 0;
	my @file;
	
    if (-e $news_file) {
        open(F, $news_file) || die &PrintErrorPage("Can't open news file '$news_file'\n");
        @file = <F>;
        close(F);
    }
    
    open(F, ">$news_file") || die &PrintErrorPage("Can't write to news file '$news_file'\n");
    print F $newsitem;
    foreach (@file) {
        $i++ if (/^<!-- NEWSADMIN: DO NOT REMOVE THIS LINE! -->/);
        
        print F if ($i < $number_of_news);
    }
    close(F);	
}

##############################################################################

sub WriteHeadlines {
	my $content = $_[0];
	my $i = 0;
	my @file;

    if (-e $headlines_file) {
        open(F, $headlines_file) || die &PrintErrorPage("Can't open headlines file '$headlines_file'\n");
        @file = <F>;
        close(F);
    }
    
    open(F, ">$headlines_file") || die &PrintErrorPage("Can't write to headlines file '$headlines_file'\n");
    print F $content;
    foreach (@file) {
        $i++ if (/^<!-- NEWSADMIN: DO NOT REMOVE THIS LINE! -->/);

        print F if ($i < $number_of_headlines);
    }
    close(F);		
}

##############################################################################

sub ParseNewsTemplate {
	my ($id, $headline, $timestamp, $author, $email, $text) = @_;
	my $content;

	$content .= "\n<!-- NEWSADMIN: DO NOT REMOVE THIS LINE! -->\n";
	$content .= "<a name=\"$id\"></a>\n";

	open(F, $newsitem_template) || die &PrintErrorPage("Can't open news template '$newsitem_template'\n");
	while (<F>) {
		$content .= ReplaceTemplateTags($_, $id, $headline, $timestamp, $author, $email, $text);
	}
	close(F);
	
	# Convert double linefeeds to <p>
	if ($in{'linefeedconv'}) {
		$content =~ s/(\r|\n){4,}/<p>\n\n/g;
	}
	
	return $content;
}

##############################################################################

sub ParseHeadlineTemplate {
	my ($id, $headline, $timestamp, $author, $email, $text) = @_;
	my $content;
	
	$content .= "\n<!-- NEWSADMIN: DO NOT REMOVE THIS LINE! -->\n";
	open(F, $headline_template) || die &PrintErrorPage("Can't open headline template '$headline_template'\n");
	while (<F>) {
		$content .= ReplaceTemplateTags($_, $id, $headline, $timestamp, $author, $email, $text);
	}
	close(F);	

	return $content;
}

##############################################################################

sub ReplaceTemplateTags {
	my ($content, $id, $headline, $timestamp, $author, $email, $text) = @_;
	
	$content =~ s/\[%NA-HEADLINE\]/$headline/;
	$content =~ s/\[%NA-TIMESTAMP\]/$timestamp/;
	$content =~ s/\[%NA-AUTHOR\]/$author/;
	$content =~ s/\[%NA-EMAIL\]/$email/;
	$content =~ s/\[%NA-TEXT\]/$text/;
	$content =~ s/\[%NA-ID\]/$id/;
	
	return $content;
}

##############################################################################

sub GetDateString {
	my $formatstring = $dateformat;
	my %datestr;
	my ($sec, $min, $hour, $day, $month, $year, $weekday) = localtime($^T);
	
	$datestr{'sec'} = $sec;
	$datestr{'sec0'} = sprintf("%02d", $sec);
	
	$datestr{'min'} = $min;
	$datestr{'min0'} = sprintf("%02d", $min);
	
	$datestr{'hour24'} = $hour;
	$datestr{'hour240'} = sprintf("%02d", $hour);
	
	$datestr{'ampm'} = ($hour > 12) ? 'pm' : 'am';
	
	 $hour -= 12 if $hour > 12;
	 $hour = 12 if ($hour == 0);
	
	$datestr{'hour'} = $hour;
	$datestr{'hour0'} = sprintf("%02d", $hour);
	
	$datestr{'day'} = $day;
	$datestr{'day0'} = sprintf("%02d", $day);
	
	$datestr{'dayname'} = $daynames[$weekday];
	$datestr{'daynameshort'} = substr($daynames[$weekday], 0, 3);
	
	$datestr{'month'} = $month + 1;
	$datestr{'month0'} = sprintf("%02d", $month + 1);
	$datestr{'monthname'} = $monthnames[$month];
	$datestr{'monthnameshort'} = substr($monthnames[$month], 0, 3);
	
	$datestr{'year'} = 1900 + $year;
	$datestr{'shortyear'} = sprintf("%02d", $year % 100);
	
	while ($formatstring =~ /\[([^\]]+)\]/) {
		my $tag = $1;
		$formatstring =~ s/\[$tag\]/$datestr{$tag}/;
	}

	return $formatstring;
}

##############################################################################

sub CheckPassword {
	my $pw_match = 0;
	
	foreach(@passwords) {
		$pw_match = 1 if ($_ eq $in{'password'});
	}
	
	return $pw_match;
}

##############################################################################

sub ReadParse {
	my $buf, @pairs;
	
    if ($ENV{'REQUEST_METHOD'} eq 'GET') {
        @pairs = split(/&/, $ENV{'QUERY_STRING'});
    } elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
        read(STDIN, $buf, $ENV{'CONTENT_LENGTH'});
        @pairs = split(/&/, $buf);
    }

    foreach (@pairs) {
        local($key, $val) = split(/=/);
 
        $key  =~ tr/+/ /;
        $val =~ tr/+/ /;

        $key  =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

        $val =~ s/<!--(.|\n)*-->//g; # Strip SSI

		$in{$key} = $val;
	}
}

##############################################################################

sub CookieParse {
	if ($ENV{'HTTP_COOKIE'}) {
		my @pairs = split(/; /, $ENV{'HTTP_COOKIE'});	
		
		foreach (@pairs) {
			local($key, $val) = split(/=/);
			$cookie{$key} = $val;
		}
	}
}

##############################################################################

sub VerifyFailed {
	print "Content-type: text/html\n\n";
	
	&PrintHead;
	
	print "<b>Error!</b><p>\n";
	
	print "<ul>\n";
	print "<li>Author missing<br>\n" if ($in{'author'} eq '');
	print "<li>E-Mail missing<br>\n" if ($in{'email'} eq '');
	print "<li>Headline missing<br>\n" if ($in{'headline'} eq '');
	print "<li>Text missing<br>\n" if ($in{'text'} eq '');
	print "<li>Wrong password!\n" if (!&CheckPassword);
	print "</ul>\n";

	print "<p><b>Press the back button in your browser to get back.</b>";
	
	&PrintFoot;
}

##############################################################################

sub PrintErrorPage {
	print "Content-type: text/html\n\n";

	&PrintHead;

	print "<b>Script error!</b><p>\n";
	print $_[0];

	&PrintFoot;
}

##############################################################################

sub PrintPostedPage {
	print "Content-type: text/html\n\n";
	
	&PrintHead;

	print "News posted!<p>\n";
	print "<a href=\"$ENV{'HTTP_REFERER'}\">Back</a>\n";

	&PrintFoot;
}

##############################################################################

sub PrintInputPage {

print "Content-type: text/html\n\n";

&PrintHead;

print <<HTML_END;

<center>
<table cellspacing="0" cellpadding="8" border=0 width="100%">
<form action="$ENV{'SCRIPT_NAME'}" method="POST">
<input type="hidden" name="action" value="post">
<tr bgcolor="#223D74">
	<td>
	<font face="verdana, arial, geneva" size="-1" color="#ffffff"><b>NewsAdmin</b></font>
	<font face="verdana, arial, geneva" size="-2" color="#ffffff">
	v$VERSION (c) Stefan Pettersson
	</font>
	</td>

	<td align=right>
	<font face="verdana, arial, geneva" size="-2" color="#ffffff">
	<a href="http://www.stefan-pettersson.nu/cgi-bin/referer.pl?newsadmin">NewsAdmin Homepage</a>
	</font>
	</td>
</tr>
<tr>
    <td valign=top>

        <table>
        <tr>
            <td><font face="verdana, arial, geneva" size="-1"><b>Author:</b></font></td>
            <td><input type="text" name="author" size=40 value="$cookie{"$ENV{'SCRIPT_NAME'}_AUTHOR"}"></td>
        </tr>
        <tr>
            <td><font face="verdana, arial, geneva" size="-1"><b>E-Mail:</b></font></td>
            <td><input type="text" name="email" size=40 value="$cookie{"$ENV{'SCRIPT_NAME'}_EMAIL"}"></td>
        </tr>
        <tr>
            <td><font face="verdana, arial, geneva" size="-1"><b>Headline:</b></font></td>
            <td><input type="text" name="headline" size=40></td>
        </tr>
        <tr>
            <td valign=top><font face="verdana, arial, geneva" size="-1"><b>Text:</b></font></td>
            <td>
            <textarea name="text" cols=50 rows=10></textarea>
            </td>
        </tr>
        <tr>
            <td><font face="verdana, arial, geneva" size="-1"><b>Password:</b></font></td>
            <td><input type="password" name="password" size=40></td>
        </tr>            <tr>
            <td><br></td>
            <td>
                <input type="submit" name="preview" value=" Preview ">
                <input type="submit" value=" Post ">
            </td>
        </tr>
        </table>

    </td>

    <td valign=top width="100%">

<!--
        <font face="verdana, arial, geneva" size="-1"><b>Note</b><br>
        <font face="verdana, arial, geneva" size="-1">
        Here you might enter your own message. Uncomment and it'll show up.<p>
        </font>
-->
        <font face="verdana, arial, geneva" size="-1"><b>Options</b><br>
        <font face="verdana, arial, geneva" size="-2">
        <input type="checkbox" name="linefeedconv" checked>Convert double linefeeds into HTML<p>
        </font>

    </td>
</tr>
</form>
</table>

</center>

HTML_END

&PrintFoot;

}

##############################################################################

sub PrintHead {

print <<HTML_END;

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
	<title>NewsAdmin</title>
</head>

<body bgcolor="#15284F" text="#ffffff" link="#CFDBF3" vlink="#CFDBF3" alink="#ffffff">
<font face="verdana, arial, geneva" size="-1">

HTML_END

}

##############################################################################

sub PrintFoot {

print <<HTML_END;

</font>
</body>
</html>

HTML_END

}

##############################################################################
