#!/usr/local/bin/perl

#######################################################################
#							                            # 
#                          News Publisher 	                      #
#                             Archives                                #
#		   	          Version 1.02                              #
# 	                                                                #
#                    Created by Grant Williams                        # 
#					                                        #
# Created on:  6/11/99          Last Modified on:  8/16/99            #
# I can be reached at:          gcw07@ionet.net                       #
# Scripts Found at:             http://www.roosh.com/news_publisher/  #
#######################################################################
# Please use the forum at the site for support questions and not      #
# email them. The forum is checked often.				          #
#######################################################################
# COPYRIGHT NOTICE:								    #
# 										          #
# Copyright 1999 - 2000   Grant Williams    All Rights Reserved.      #
#											    #
# This program may be used and modified free of charge by anyone, as  #
# long as this copyright notice and the header above remain intact.   #  
# By using this program you agree to indemnify Grant Williams from    #
# any liability that might arise from it's use.                       #
#											    #
# Selling the code for this program without prior written consent is  #
# expressly forbidden. Obtain permission before redistributing this   #
# software over the Internet or in any other medium.  In all cases    #
# copyright and header must remain intact.                            #
#                                                                     #
#######################################################################
# Define Variables

require "config.cgi";
require "np-lib.cgi";

##########################################################################
# 												 #
#    DO NOT EDIT BELOW THIS LINE							 #
#												 #
##########################################################################

&parse_query;
&get_general_configuration;
&get_individual_configuration;

@text_months = ("January","February","March","April","May","June","July","August","September","October","November","December");
print "Content-Type: text/html\n\n";

&pageheader;

if($query{'view'}){
	if($archivetype == 2){
		&viewweek;
	}
	else{
		&viewmonth;
	}
}
else{
	if($archivetype == 2){
		&viewweeklist;
	}
	else{
		&viewmonthlist;
	}
}
&pagefooter;

######################

sub viewmonthlist {
	if($query{'category'}){
		$cat_database = $query{'category'};
	}
	else {
		$cat_database = 1;
	}
	####
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
		close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();

	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
      		close(DIR);
			
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
			@temp_data = <DIR>;
     		close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
  			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}

	####
	print "$archivesname";

	foreach $line (@data) {
		@dataA = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$dataA[0]);
		$dataA[0] = $temp_date;

		($month,$day,$year) = split(/\//,$dataA[0]);
 
		$newmonth = "$month-$year";

		if ($newmonth ne $prevmonth){
			push (@months, $newmonth);
		}
		$prevmonth = $newmonth;
	}

	foreach $monthA (@months) {
		($monthNum,$yearNum) = split(/\-/,$monthA);
		$tmonth = $monthNum - 1;
		$yearNum += 100 if($yearNum < 90); 
		$fullyear = 1900 + $yearNum;
		$textmonth = "$text_months[$tmonth] $fullyear";

		print "<a href=\"$ArchiveScriptUrl?category=$cat_database&view=$monthA\">$textmonth</a><br>\n";
	}
}

####################################

sub viewweeklist {
	if($query{'category'}){
		$cat_database = $query{'category'};
	}
	else {
		$cat_database = 1;
	}

	####
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
		close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();

	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
      		close(DIR);
			
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
			@temp_data = <DIR>;
     		close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
  			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}

	####
	print "$archivesname";

	$dailycount = 0;
	$weeklydata = "";

	foreach $line (@data) {
		@dataA = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$dataA[0]);
		$dataA[0] = $temp_date;

		if ($dataA[0] ne $prevday){
			$dailycount++;
			if ($dailycount > 7){
				$dailycount = 1;
				push (@archiveNews, "$weeklydata\n");
				$weeklydata = "";
			}
			$weeklydata = "$weeklydata\:$dataA[0]";
		}
		$prevday = $dataA[0];
	}
	push (@archiveNews, "$weeklydata\n");

	foreach $weeklyArchive (@archiveNews) {
		chop($weeklyArchive);
		@weekdata = split(/\:/,$weeklyArchive);

		($monthA1,$dayA1,$yearA1) = split(/\//,$weekdata[1]);
		$begin = "$monthA1\.$dayA1\.$yearA1";

		@newWeekdata = @weekdata;
		$end = pop(@newWeekdata);
		($monthNum,$dayNum,$yearNum) = split(/\//,$end);
		$end = "$monthNum\.$dayNum\.$yearNum";

		$tmonth = $monthNum - 1;
		$yearNum += 100 if($yearNum < 90);
		$fullyear = 1900 + $yearNum;
		$textdate = "$text_months[$tmonth] $dayNum, $fullyear - ";

		#######
		$tmonthA = $monthA1 - 1;
		$yearA1 += 100 if($yearA1 < 90); 
		$fullyearA = 1900 + $yearA1;
		$textdate1 = "$text_months[$tmonthA] $dayA1, $fullyearA";

		print "<a href=\"$ArchiveScriptUrl?category=$cat_database&view=$end-$begin\">$textdate$textdate1</a><br>\n";

	}
}

####################################

sub viewmonth {
	if($query{'category'}){
		$cat_database = $query{'category'};
	}
	else {
		$cat_database = 1;
	}
	my $beforeDateStory = $ct_beforeDateStory{$cat_database};
	my $afterDateStory = $ct_afterDateStory{$cat_database};
	my $Cnumonnews = $ct_numonnews{$cat_database};
	my $storyDate = $ct_storyDate{$cat_database};

	####
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
		close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();

	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
      		close(DIR);
			
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
			@temp_data = <DIR>;
     		close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
  			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}

	### date ###
	($monthNum,$yearNum) = split(/\-/,$query{'view'});

	$tmonth = $monthNum - 1;
	$yearNum += 100 if($yearNum < 90); 
	$fullyear = 1900 + $yearNum;
	$textmonth = "$text_months[$tmonth] $fullyear";

	print "$beforedate$textmonth$afterdate\n";
	### date ###

	foreach $story (@data) {
		@newdata = split(/\|:\|/,$story);
		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		($monthA1,$dayA,$yearA) = split(/\//,$newdata[0]);
		$newmonthA = "$monthA1-$yearA";

		if ($newmonthA eq $query{'view'}){	

			%hash = (
				0 => '<<date>>',
				1 => '<<author>>',
				2 => '<<email>>', 
				3 => '<<time>>',
				4 => '<<subject>>',
				5 => '<<byline>>',
				6 => '<<id>>',
				7 => '<<story>>',
			);

			$storybodytemp = $ct_storybody{$cat_database};

			if ($newdata[0] ne $prevdate){
				&getdate("$newdata[6]","$storyDate");
				print "$beforeDateStory$returndate$afterDateStory\n\n";
			}

			for($i=0; $i < 8; $i++){
		   		$storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
			}
		
			if ($cg_comment_system == 2){
				&getComment("$newdata[6]");
				$storybodytemp =~ s/(<<comments>>)/$more/;
			}
			if($cg_use_categories == 2){
				$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
			}

			print "$storybodytemp\n";

	$more = "";
	$prevdate = $newdata[0];

	} #end if
	} #end foreach
}

####################################

sub viewweek {
	if($query{'category'}){
		$cat_database = $query{'category'};
	}
	else {
		$cat_database = 1;
	}
	my $beforeDateStory = $ct_beforeDateStory{$cat_database};
	my $afterDateStory = $ct_afterDateStory{$cat_database};
	my $Cnumonnews = $ct_numonnews{$cat_database};
	my $storyDate = $ct_storyDate{$cat_database};

	####
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
		close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();

	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
      		close(DIR);
			
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
			@temp_data = <DIR>;
     		close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
  			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}

	### date ###

	($firstDate,$secondDate) = split(/\-/,$query{'view'});

	($monthA1,$dayA1,$yearA1) = split(/\./,$secondDate);

	($monthNum,$dayNum,$yearNum) = split(/\./,$firstDate);
	$tempbegin = "$monthNum/$dayNum/$yearNum";

	$tmonth = $monthNum - 1;
	$yearNum += 100 if($yearNum < 90);
	$fullyear = 1900 + $yearNum;
	$textdate = "$text_months[$tmonth] $dayNum, $fullyear - ";

	#######
	$tmonthA = $monthA1 - 1;
	$yearA1 += 100 if($yearA1 < 90); 
	$fullyearA = 1900 + $yearA1;
	$textdate1 = "$text_months[$tmonthA] $dayA1, $fullyearA";

	print "$beforedate$textdate$textdate1$afterdate\n";
	### date ###

	$dailycount = 0;
	$weeklydata = "";

	foreach $line (@data) {
		@dataA = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$dataA[0]);
		$dataA[0] = $temp_date;

		if ($dataA[0] ne $prevday){
			$dailycount++;
			if ($dailycount > 7){
				$dailycount = 1;
				push (@archiveNews, "$weeklydata\n");
				$weeklydata = "";
			}
			$weeklydata = "$weeklydata\:$dataA[0]";
		}
		$prevday = $dataA[0];
	}
	push (@archiveNews, "$weeklydata\n");

	foreach $weeklyArchive (@archiveNews) {
		chop($weeklyArchive);
		if($weeklyArchive =~ /$tempbegin/i){
			@weekdata = split(/\:/,$weeklyArchive);
		}
	}

	$prevdate = 0;

	undef %unweeklydata;
	for (@weekdata) { $unweeklydata{$_} = 1;}

	foreach $story (@data) {
		@newdata = split(/\|:\|/,$story);
		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		if ($unweeklydata{$newdata[0]}){
	
			%hash = (
				0 => '<<date>>',
				1 => '<<author>>',
				2 => '<<email>>', 
				3 => '<<time>>',
				4 => '<<subject>>',
				5 => '<<byline>>',
				6 => '<<id>>',
				7 => '<<story>>',
			);

			$storybodytemp = $ct_storybody{$cat_database};

			if ($newdata[0] ne $prevdate){
				&getdate("$newdata[6]","$storyDate");
				print "$beforeDateStory$returndate$afterDateStory\n\n";
			}

			for($i=0; $i < 8; $i++){
				$storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
			}
		
			if ($cg_comment_system == 2){
				&getComment("$newdata[6]");
				$storybodytemp =~ s/(<<comments>>)/$more/;
			}
			if($cg_use_categories == 2){
				$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
			}
			print "$storybodytemp\n";

	$more = "";
	$prevdate = $newdata[0];
	} #end if
	} #end foreach
}

##################


