#!/usr/local/bin/perl

#######################################################################
#							                            # 
#                   News Publisher Search	Engine                      #
#		   	          Version 1.04                              #
# 	                                                                #
#                    Created by Grant Williams                        # 
#					                                        #
# Created on:  2/09/99          Last Modified on:  8/16/99            #
# I can be reached at:          gcw07@ionet.net                       #
# Scripts Found at:             http://www.roosh.com/news_publisher/  #
#######################################################################
# Please use the forum at the site for support questions and not      #
# email them. The forum is checked often.				          #
#######################################################################
# COPYRIGHT NOTICE:								    #
# 										          #
# Copyright 1999 - 2000   Grant Williams    All Rights Reserved.      #
#											    #
# This program may be used and modified free of charge by anyone, as  #
# long as this copyright notice and the header above remain intact.   #  
# By using this program you agree to indemnify Grant Williams from    #
# any liability that might arise from it's use.                       #
#											    #
# Selling the code for this program without prior written consent is  #
# expressly forbidden. Obtain permission before redistributing this   #
# software over the Internet or in any other medium.  In all cases    #
# copyright and header must remain intact.                            #
#                                                                     #
#######################################################################
# Define Variables

require "config.cgi";
require "np-lib.cgi";

##########################################################################
# 												 #
#    DO NOT EDIT BELOW THIS LINE							 #
#												 #
##########################################################################

&parse_query;
&parse_form;
&get_general_configuration;
&get_individual_configuration;

if($query{'category'}){
	$cat_database = $query{'category'};
}
else {
	$cat_database = 1;
}

if (! $query{'page'}){
	$beginat = 1; 
	$endat = $perpagedisplay;
	$currentpage = 1;	
}
else {
	$pagenum = $query{'page'};
	$pagenum = ($pagenum-1)*$perpagedisplay;

	$beginat = $pagenum + 1; 
	$endat = $pagenum + $perpagedisplay;
	$currentpage = $query{'page'};
}

print "Content-Type: text/html\n\n";

&pageheader;

print "$beforeForm\n";
print "<form action=\"$SearchScriptUrl\" method=\"get\">\n";
print "<input type=\"hidden\" name=\"category\" value=\"$cat_database\">\n";
print "<input type=\"text\" name=\"keyword\" size=\"20\" maxsize=\"30\">\n";
print "<input type=\"submit\" value=\"Search\">\n";
print "</form>\n";
print "$afterForm\n";

$keyword = $query{'keyword'};
$keyword =~ tr/+/ /;
$keyword =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
$keyword =~ s/<!--(.|\n)*-->//g;
$keyword =~ s/<([^>]|\n)*>//g;

if (! $query{'keyword'}){
	print "<center>Please enter a keyword or words.</center>\n";
	&pagefooter;
	exit;
}

###
@cat_data = ();
if(! -e "$datadir/categories.file"){
	push (@cat_data, "1|:|Default\n");
}
else {
	open(DIR,"$datadir/categories.file");
		@cat_data = <DIR>;
	close(DIR);
}
push (@category_names, "");

@data = @temp_data = @temp_data2 = ();

if($cat_database eq "all"){
	foreach $allcategorylist (@cat_data){
		chomp($allcategorylist);                    
		($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
		push (@category_names, $cat_data_Name);

		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_data_Id_h\.news");
     			@temp_data = <DIR>;
      	close(DIR);
			
		foreach $tmp_line (@temp_data){
			$tmp_line2 = "$cat_data_Id_h,$tmp_line";
			push (@temp_data2, $tmp_line2);
		}
		push (@data, @temp_data2);
	}
	@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
}
else {
	@temp_data = @temp_data2 = ();
	open(DIR,"$datadir/$cat_database\.news");
		@temp_data = <DIR>;
     	close(DIR);

	foreach $allcategorylist (@cat_data){
		chomp($allcategorylist);                    
  		($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
		push (@category_names, $cat_data_Name);

		if($cat_data_Id_h == $cat_database){
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
	}
}

foreach $line (@data) {
	chop($line);                    
   	($date, $author, $email, $texttime, $subject, $byline, $id, $story) = split(/\|:\|/,$line);
	($temp_category_num, $temp_date) = split(/\,/,$date);
	$date = $temp_date;

	if (($date =~ /$keyword/i) || ($author =~ /$keyword/i) || ($subject =~ /$keyword/i)
		|| ($byline =~ /$keyword/i) || ($story =~ /$keyword/i)) {
		push(@results, $line);
		$matches++;
	}
}

if ($matches == 0){
	print "<center>No matches were found for <b>$keyword</b><P>Sorry there is no text with that search criteria.</center>";
	&pagefooter;
	exit;
}

###########

$beforeDateStory = $ct_beforeDateStory{$cat_database};
$afterDateStory = $ct_afterDateStory{$cat_database};
$Cnumonnews = $ct_numonnews{$cat_database};
$storyDate = $ct_storyDate{$cat_database};

$pages = $matches/$perpagedisplay;
$pages_remainder = $matches % $perpagedisplay;

$pages = ($pages - ($pages_remainder/$perpagedisplay));

if ($pages_remainder){ $pages++;  }

&printallpages;

$prevdate = 0;

foreach $line (@results) {
	$count++;		
	if ( ($count >= $beginat) && ($endat >= $count) ){
		%hash = (
			0 => '<<date>>',
			1 => '<<author>>',
			2 => '<<email>>', 
			3 => '<<time>>',
			4 => '<<subject>>',
			5 => '<<byline>>',
			6 => '<<id>>',
			7 => '<<story>>',
		);
		$storybodytemp = $ct_storybody{$cat_database};
		@newdata = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		if ($newdata[0] ne $prevdate){
			&getdate("$newdata[6]","$storyDate");
			print "$beforeDateStory$returndate$afterDateStory\n\n";
		}

		$newdata[0] =~ s/($keyword)/$beforeSearch$1$afterSearch/ig;
		$newdata[1] =~ s/($keyword)/$beforeSearch$1$afterSearch/ig;
		$newdata[4] =~ s/($keyword)/$beforeSearch$1$afterSearch/ig;
		$newdata[5] =~ s/($keyword)/$beforeSearch$1$afterSearch/ig;
		if ($newdata[7] !~ /<a href=(.*)>/i){
			$newdata[7] =~ s/($keyword)/$beforeSearch$1$afterSearch/ig;
		}

		for($i=0; $i < 8; $i++){  #scalar(@newdata)
		   $storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
		}

		if ($cg_comment_system == 2){
			&getComment("$newdata[6]");
			$storybodytemp =~ s/(<<comments>>)/$more/;
		}
		if($cg_use_categories == 2){
			$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
		}

		print "$storybodytemp\n";

   $more = "";		
   $prevdate = $newdata[0];
   }
}

if ($currentpage != $pages){
	&printallpages;
}

&pagefooter;

############

sub printallpages {
	print "Results: Page $currentpage of $pages<br>\n";
	print "Next Pages: ";
	$keyword =~ tr/ /+/;
	for($i=1; $i<=$pages; $i++){
		if ($currentpage == $i){
			print "($i) ";
		}
		else {
			print "<A HREF=\"$SearchScriptUrl?category=$cat_database&keyword=$keyword&page=$i\">$i</A> "; 
		}
	}
	print "<P>\n";
	$keyword =~ tr/+/ /;
}

