#!/usr/local/bin/perl

#######################################################################
#							                            # 
#                          News Publisher                             #
#                        Single Story Viewer 	                      #
#		   	          Version 1.04                              #
# 	                                                                #
#                    Created by Grant Williams                        # 
#					                                        #
# Created on:  3/27/99          Last Modified on:  8/16/99            #
# I can be reached at:          gcw07@ionet.net                       #
# Scripts Found at:             http://www.roosh.com/news_publisher/  #
#######################################################################
# Please use the forum at the site for support questions and not      #
# email them. The forum is checked often.				          #
#######################################################################
# COPYRIGHT NOTICE:								    #
# 										          #
# Copyright 1999 - 2000   Grant Williams    All Rights Reserved.      #
#											    #
# This program may be used and modified free of charge by anyone, as  #
# long as this copyright notice and the header above remain intact.   #  
# By using this program you agree to indemnify Grant Williams from    #
# any liability that might arise from it's use.                       #
#											    #
# Selling the code for this program without prior written consent is  #
# expressly forbidden. Obtain permission before redistributing this   #
# software over the Internet or in any other medium.  In all cases    #
# copyright and header must remain intact.                            #
#                                                                     #
#######################################################################
# Define Variables

require "config.cgi";
require "np-lib.cgi";

##########################################################################
# 												 #
#    DO NOT EDIT BELOW THIS LINE							 #
#												 #
##########################################################################

&parse_query;
&get_general_configuration;
&get_individual_configuration;

print "Content-Type: text/html\n\n";
&pageheader;

if($query{'id'}){
	&viewstory;
}
else{
	&viewheadlines;
}
&pagefooter;

#####################

sub viewheadlines {
	if($query{'category'}){
		$cat_database = $query{'category'};
	}
	else {
		$cat_database = 1;
	}

	my $beforeDateHeadline = $ct_beforeDateHeadline{$cat_database};
	my $afterDateHeadline = $ct_afterDateHeadline{$cat_database};
	my $Cnumonheadlines = $ct_numonheadlines{$cat_database};
	my $headlineDate = $ct_headlineDate{$cat_database};
	my $headlineCount = $ct_headlineCount{$cat_database};
	my $id = $query{'id'};

	###
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
		close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();

	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
			close(DIR);
	
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
			@temp_data = <DIR>;
     		close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
  			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}

	$numcount = 0;
	$prevdate = 0;
	$dailycount = 0;

	foreach $line (@data) {
		$numcount++;
		if (($numcount > $Cnumonheadlines) && ($headlineCount == 2)){
			last;
		}
     	   	
		%hash = (
			0 => '<<date>>',
			1 => '<<author>>',
			2 => '<<email>>', 
			3 => '<<time>>',
			4 => '<<subject>>',
			5 => '<<byline>>',
			6 => '<<id>>',
		);
		$headlinetemp = $ct_headlinebody{$cat_database};
		@newdata = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		if ($newdata[0] ne $prevdate){
			$dailycount++;

			if (($dailycount > $Cnumonheadlines) && ($headlineCount == 1)){
				last;
			}

			&getdate("$newdata[6]","$headlineDate");	
		      
			if ($headlineDate != 8){	     
				print "$beforeDateHeadline$returndate$afterDateHeadline\n\n";
			}
		}

		for($i=0; $i < 7; $i++){
		   $headlinetemp =~ s/$hash{$i}/$newdata[$i]/;	
		}

		if ($cg_comment_system == 2){
			&getComment("$newdata[6]");
			$headlinetemp =~ s/(<<comments>>)/$more/;
		}
		if($cg_use_categories == 2){
			$headlinetemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
		}

		print "$headlinetemp\n";
	
	$more = "";	
   	$prevdate = $newdata[0];
	}
}

#######################

sub viewstory {
	if($query{'category'}){
		$cat_database = $query{'category'};
	}
	else {
		$cat_database = 1;
	}

	my $beforeDateStory = $ct_beforeDateStory{$cat_database};
	my $afterDateStory = $ct_afterDateStory{$cat_database};
	my $Cnumonnews = $ct_numonnews{$cat_database};
	my $storyDate = $ct_storyDate{$cat_database};
	my $id = $query{'id'};

	###
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
		close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();

	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
			close(DIR);
	
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
			@temp_data = <DIR>;
     		close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
  			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}
	
	$count = 0;
	$prevdate = 0;

	foreach $line (@data) {
     	   
		%hash = (
			0 => '<<date>>',
			1 => '<<author>>',
			2 => '<<email>>', 
			3 => '<<time>>',
			4 => '<<subject>>',
			5 => '<<byline>>',
			6 => '<<id>>',
			7 => '<<story>>',
		);
		$storybodytemp = $ct_storybody{$cat_database};
		@newdata = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		if ("$newdata[6]" eq "$id"){
			&getdate("$newdata[6]","$storyDate");	

			if ($storyDate != 8){      
				print "$beforeDateStory$returndate$afterDateStory\n\n";
			}

			for($i=0; $i < 8; $i++){
				$storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
			}
		
			if ($cg_comment_system == 2){
				&getComment("$newdata[6]");
				$storybodytemp =~ s/(<<comments>>)/$more/;
			}
			if($cg_use_categories == 2){
				$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
			}

			print "$storybodytemp\n";
			$more = "";		
		}#end if
	}
	print "$seperator\n";
	if($print_headlines == 1){
		&viewheadlines;
	}
}
