#######################################################################
#							                            # 
#                          News Publisher 	                      #
#		   	          Version 1.06                              #
# 	                                                                #
#                    Created by Grant Williams                        # 
#					                                        #
# Created on:  11/02/98         Last Modified on:  8/12/99            #
# I can be reached at:          gcw07@ionet.net                       #
# Scripts Found at:             http://www.roosh.com/news_publisher/  #
#######################################################################
# Please use the forum at the site for support questions and not      #
# email them. The forum is checked often.				          #
#######################################################################
# COPYRIGHT NOTICE:								    #
# 										          #
# Copyright 1999 - 2000    Grant Williams    All Rights Reserved.     #
#											    #
# This program may be used and modified free of charge by anyone, as  #
# long as this copyright notice and the header above remain intact.   #  
# By using this program you agree to indemnify Grant Williams from    #
# any liability that might arise from it's use.                       #
#											    #
# Selling the code for this program without prior written consent is  #
# expressly forbidden. Obtain permission before redistributing this   #
# software over the Internet or in any other medium.  In all cases    #
# copyright and header must remain intact.                            #
#                                                                     #
#######################################################################
#                                                                     #
# News Publisher Library                                              #
# NO NEED TO EDIT THIS FILE. LEAVE AS IS, AND JUST UPLOAD IT IN THE   #
# SAME DIRECTORY AS THE NEWS.CGI AND CONFIG.CGI ARE IN.               #
#                                                                     #
#######################################################################


#####################    GENERAL CODE    ######################

sub header {
	print "Content-Type: text/html\n\n";
	print "<HTML><HEAD>\n";
	print "<TITLE>News Publisher $site_identification</TITLE>\n";
	print "</HEAD>\n";
	print "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\">\n";

	print "<center><h2>News Publisher $site_identification</h2></center>\n";
}

#####################

sub footer {
	print "</td></tr>\n";
	print "</table>\n";
	print "</center>\n";
	print "<P><center><a href=\"http://www.roosh.com/news_publisher/index.shtml\">News Publisher</a> Version $Version<br>Copyright  1999 by Grant Williams</center>\n";
	print	"</body></html>\n";
}

##############

sub pageheader {
	open (FILE,"$pageheader"); 
 		@pageheaderfile = <FILE>;
 	close(FILE);

	foreach $hline (@pageheaderfile) {
		print "$hline";
  	}
}

##############

sub pagefooter {
	open (FILE,"$pagefooter");
 		@pagefooterfile = <FILE>;
 	close(FILE);

	foreach $fline (@pagefooterfile) {
		print "$fline";
	}
}

##################

sub parse_form {

	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
      @pairs = split(/&/, $buffer);

      foreach $pair (@pairs) {
       	($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
          	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
          	$value =~ s/<!--(.|\n)*-->//g;
		$value =~ s/\|:\|//g;

          	$FORM{$name} = $value;
       }
}

#############

sub parse_query {

	@arguments = split('&', $ENV{QUERY_STRING});
	foreach $argument (@arguments){
		($name, $value) = split ('=', $argument);
		$query{"$name"} = $value;
	}
}

#####################    NEWS PUBLISHER CODE    ######################

sub menu {
	my $name = $_[0];
	my $password = $_[1];
	my $default = $_[2];

	&check_passwd("$name","$password");	
	if ($flag == 1){
	&CheckAdminLevel("$name");

	%admin_menu = (
		"0"		=> "- Select Option -",
		"1B"  	=> "View All Stories",
		"2A"  	=> "Configuration",
		"3A" 		=> "Author Options",
		"4A" 		=> "Autolink Options",
		"5A"		=> "Category Options",
		"8B"  	=> "Update News File",
		"9B"  	=> "Sign Out",
	);

	%useradmin_menu = (
		"0"		=> "- Select Option -",
		"1B"		=> "View All Stories",
		"2U" 		=> "Add New Story",
		"3A" 		=> "Author Options",
		"4A"		=> "Autolink Options",
		"8B"  	=> "Update News File",
		"9B"  	=> "Sign Out",
	);

	%user_menu = (
		"0"		=> "- Select Option -",
		"1B"		=> "View All Stories",
		"2U" 		=> "Add New Story",
		"4U" 		=> "Edit Information",
		"8B"  	=> "Update News File",
		"9B"  	=> "Sign Out",
	);

	print "<center>\n";
	print "<table border=1 cellpadding=3 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#cecece\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center>\n";
	print "<form action=\"$NewsScriptUrl\" method=\"post\">\n";
	print "<font size=3><b>Menu</b></font><br>\n";
	print "<select size=1 name=\"select\">\n";

   	if ($name eq "admin"){
		foreach $item (sort keys %admin_menu) {
  			if ($admin_menu{$item} eq $default) {
   				print "<option selected value=\"$item\">$admin_menu{$item}\n";
  			}
  			else {
				if($item eq "5A" && $cg_use_categories != "2"){}
				else{
   					print "<option value=\"$item\">$admin_menu{$item}\n";
				}
  			}
 		}
   	}
   	elsif($name eq "$username" && $userlevel == 1) {
		foreach $item (sort keys %useradmin_menu) {
  			if ($useradmin_menu{$item} eq $default) {
   				print "<option selected value=\"$item\">$useradmin_menu{$item}\n";
  			}
  			else {
   				print "<option value=\"$item\">$useradmin_menu{$item}\n";
  			}
 		}
   	}
   	else {
		foreach $item (sort keys %user_menu) {
  			if ($user_menu{$item} eq $default) {
   				print "<option selected value=\"$item\">$user_menu{$item}\n";
  			}
  			else {
				if($item eq "4U" && $cg_authoredit != "1"){}
				else{
   					print "<option value=\"$item\">$user_menu{$item}\n";
				}
  			}
 		}
   	}
	print "</select>\n";
	print "<input type=\"hidden\" name=\"name\" value=\"$name\">\n";
	print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
	print "<input type=\"submit\" value=\"Select\">\n";

	print "</form></center>\n";

	print "</td></tr></table></center><P>\n";

	print "<center>\n";
	print "<table border=1 cellpadding=3 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#cecece\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";
	}
	else {
		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);      
		$month = ($mon + 1);		
		open(LOG, ">>$datadir/accessLog.txt");
		print LOG "ACCESS DENIED : $month\/$mday\/$year at $hour:$min:$sec - tried from $ENV{'REMOTE_ADDR'}\n";
		close(LOG);

		print "<center>\n";
		print "<table border=1 cellpadding=3 cellspacing=1 width=100\%>\n";
		print "<tr bgcolor=\"#cecece\">\n";
		print "<td colspan=1 rowspan=1 valign=top align=left>\n";
		print "<center><strong>Error</strong></center><hr>\n";
		print "The name and password are wrong. You must login before entering a restricted area.\n";

		&footer;
		exit(0);
	}
}

########################

sub get_general_configuration {

	open(DIR,"$datadir/NP.setup");
     	  @data = <DIR>;
      close(DIR);

	foreach $line (@data) {
		chop($line);                    
   		($cname, $cvalue) = split(/\|:\|/,$line);
		if($cname eq "authoredit"){
			$cg_authoredit = $cvalue;
		}
		elsif($cname eq "encryption"){
			$cg_encryption = $cvalue;
		}
		elsif($cname eq "oldmessages"){
			$cg_oldmessages = $cvalue;
		}
		elsif($cname eq "timeoffset"){
			$cg_timeoffset = $cvalue;
		}
		elsif($cname eq "archivetype"){
			$cg_archivetype = $cvalue;
		}
		elsif($cname eq "comment_system"){
			$cg_comment_system = $cvalue;
		}
		elsif($cname eq "htmlSource"){
			$cg_htmlSource = $cvalue;
		}
		elsif($cname eq "useByline"){
			$cg_useByline = $cvalue;
		}
		elsif($cname eq "use_categories"){
			$cg_use_categories = $cvalue;
		}
		elsif($cname eq "special_category"){
			$cg_special_category = $cvalue;
		}
	}
}

#################

sub get_individual_configuration {

	if(! -e "$datadir/categories.file"){
		push (@configuration, "1");
	}
	else {
		open(DIR,"$datadir/categories.file");
     	  		@data = <DIR>;
      	close(DIR);

		foreach $line (@data){
			chop($line);                    
   			($catId, $catName) = split(/\|:\|/,$line);
			push (@configuration, $catId);
		}
		if($cg_special_category == 2){
			push (@configuration, "all");
		}
	}

	foreach $temp_cat (@configuration) {
		open(DIR,"$datadir/$temp_cat.conf");
     	  		@temp_config = <DIR>;
     		close(DIR);

		foreach $var (@temp_config) {
			chop($var);
   			($conf_name, $conf_value) = split(/\|:\|/,$var);

			## HEADLINES CONFIGURATIONS ##
			if($conf_name eq "beforeDateHeadline"){
				$ct_beforeDateHeadline{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "afterDateHeadline"){
				$ct_afterDateHeadline{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "numonheadlines"){
				$ct_numonheadlines{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "headlineCount"){
				$ct_headlineCount{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "headlineDate"){
				$ct_headlineDate{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "headlinebody"){
				$ct_headlinebody{$temp_cat} = $conf_value;
			}
			## NEWS CONFIGURATIONS ##
			elsif($conf_name eq "beforeDateStory"){
				$ct_beforeDateStory{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "afterDateStory"){
				$ct_afterDateStory{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "numonnews"){
				$ct_numonnews{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "newsCount"){
				$ct_newsCount{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "storyDate"){
				$ct_storyDate{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "time"){
				$ct_time{$temp_cat} = $conf_value;
			}
			elsif($conf_name eq "storybody"){
				$ct_storybody{$temp_cat} = $conf_value;
			}
		}
	}
}

################

sub getdate {
	$time = $_[0];
	$Cdate = $_[1];
		if ($cg_timeoffset ne "0") {
			$adjustTime = $time + ($cg_timeoffset * 3600);
		}
		else {
			$adjustTime = $time;
		}

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($adjustTime);

	if ($sec < 10) {
      	$sec = "0$sec";
   	}
   	if ($min < 10) {
      	$min = "0$min";
   	}
   	if ($hour < 10) {
      	$hour = "0$hour";
   	}
   	if ($mon < 10) {
      	$mon = "0$mon";
   	}
   	if ($mday < 10) {
      	$mday = "0$mday";
   	}

   	$month = ($mon + 1);

	@months = ('January','February','March','April','May','June','July','August','September','October','November','December');
	@months4 = ('Jan.','Feb.','Mar.','Apr.','May','Jun.','Jul.','Aug.','Sep.','Oct.','Nov.','Dec.');
	@wdays = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');

	if ($year > 90 && $year < 100){
		$shortyear = $year;
		$year = "19$year";
	}
	else{
		$year -= 100;
		if ($year < 10){
			$shortyear = "0$year";
			$year = "200$year";
		}
		else {
			$shortyear = "$year";
			$year = "20$year";
		}
	}

	if ($Cdate == 2){
		$returndate = "$wdays[$wday], $months[$mon] $mday, $year";
		$returndate = uc($returndate);
	}
	elsif ($Cdate == 3){
		$returndate = "$months[$mon] $mday, $year";
	}
	elsif ($Cdate == 4){
		if($mday == 1 || $mday == 21 || $mday == 31){ $mday = "$mday"."st"; }
		elsif($mday == 2 || $mday == 22 || $mday == 32){ $mday = "$mday"."nd"; }
		elsif($mday == 3 || $mday == 23 || $mday == 33){ $mday = "$mday"."rd"; }
		else { $mday = "$mday"."th"; }
		$returndate = "$months[$mon] $mday, $year";
	}
	elsif ($Cdate == 5){
		$returndate = "$months4[$mon] $mday, $year";
	}
	elsif ($Cdate == 6){
		$returndate = "$month-$mday-$shortyear";
	}
	elsif ($Cdate == 7){
		$returndate = "$month/$mday/$shortyear";
	}
	else{
		$returndate = "$wdays[$wday], $months[$mon] $mday, $year";
	}
}

#################    PRINT INFORMATION TO FILES     ##################

sub updateHeadlinefile {
	my $cat_database = $_[0];

	my $beforeDateHeadline = $ct_beforeDateHeadline{$cat_database};
	my $afterDateHeadline = $ct_afterDateHeadline{$cat_database};
	my $Cnumonheadlines = $ct_numonheadlines{$cat_database};
	my $headlineDate = $ct_headlineDate{$cat_database};
	my $headlineCount = $ct_headlineCount{$cat_database};
	
	##
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
      	close(DIR);
	}
	push (@category_names, "");

	@data = ();
	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
   			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR,"$datadir/$cat_data_Id_h\.news");
     				@temp_data = <DIR>;
      		close(DIR);
			
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_h,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
		@data = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR,"$datadir/$cat_database\.news");
     			@temp_data = <DIR>;
      	close(DIR);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
   			($cat_data_Id_h, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id_h == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id_h,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data, @temp_data2);
			}
		}
	}

	$dailycount = 0;
	$numcount = 0;
	$prevdate = 0;

	open(FILE_VH,">$datadir/$cat_database\.viewh");

	foreach $line_vh (@data) {
     	   	$numcount++;
		if (($numcount > $Cnumonheadlines) && ($headlineCount == 2)){
			last;
		}

		%hash = (
			0 => '<<date>>',
			1 => '<<author>>',
			2 => '<<email>>', 
			3 => '<<time>>',
			4 => '<<subject>>',
			5 => '<<byline>>',
			6 => '<<id>>',
		);
		$headlinetemp = $ct_headlinebody{$cat_database};
		@newdata = split(/\|:\|/,$line_vh);
		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		if ($newdata[0] ne $prevdate){
			$dailycount++;

			if (($dailycount > $Cnumonheadlines) && ($headlineCount == 1)){
				last;
			}
			&getdate("$newdata[6]","$headlineDate");	
		      
		     if ($headlineDate != 8){	     
			print FILE_VH "$beforeDateHeadline$returndate$afterDateHeadline\n\n";
		     }
		}

		for($i=0; $i < 7; $i++){
		   $headlinetemp =~ s/$hash{$i}/$newdata[$i]/;	
		}
		
		if ($cg_comment_system == 2){
			&getComment("$newdata[6]");
			$headlinetemp =~ s/(<<comments>>)/$more/;
		}
		if($cg_use_categories == 2){
			$headlinetemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
		}

		print FILE_VH "$headlinetemp\n";
	
	$more = "";	
   	$prevdate = $newdata[0];
	}
	close(FILE_VH);
}

#####################

sub updateNewsfile {
	my $cat_database = $_[0];

	my $beforeDateStory = $ct_beforeDateStory{$cat_database};
	my $afterDateStory = $ct_afterDateStory{$cat_database};
	my $Cnumonnews = $ct_numonnews{$cat_database};
	my $newsCount = $ct_newsCount{$cat_database};
	my $storyDate = $ct_storyDate{$cat_database};

	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
      	close(DIR);
	}
	push (@category_names, "");

	@data_nf = ();
	if($cat_database eq "all"){
		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
   			($cat_data_Id, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			@temp_data = @temp_data2 = ();
			open(DIR_N,"$datadir/$cat_data_Id\.news");
     				@temp_data = <DIR_N>;
      		close(DIR_N);
			
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data_nf, @temp_data2);
		}
		@data_nf = (sort { (split(/\|:\|/,$b))[6] <=> (split(/\|:\|/,$a))[6] } @data_nf);
	}
	else {
		@temp_data = @temp_data2 = ();
		open(DIR_N,"$datadir/$cat_database\.news");
     			@temp_data = <DIR_N>;
      	close(DIR_N);

		foreach $allcategorylist (@cat_data){
			chomp($allcategorylist);                    
   			($cat_data_Id, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
			push (@category_names, $cat_data_Name);

			if($cat_data_Id == $cat_database){
				foreach $tmp_line (@temp_data){
					$tmp_line2 = "$cat_data_Id,$tmp_line";
					push (@temp_data2, $tmp_line2);
				}
				push (@data_nf, @temp_data2);
			}
		}
	}
	
	$dailycount = 0;
	$numcount = 0;
	$prevdate = 0;

	open(FILE_VN,">$datadir/$cat_database\.viewn");

	foreach $line_vn (@data_nf) {
     	   	$numcount++;
		if (($numcount > $Cnumonnews) && ($newsCount == 2)){
			last;
		}
     	   
		%hash = (
			0 => '<<date>>',
			1 => '<<author>>',
			2 => '<<email>>', 
			3 => '<<time>>',
			4 => '<<subject>>',
			5 => '<<byline>>',
			6 => '<<id>>',
			7 => '<<story>>',
		);
		$storybodytemp = $ct_storybody{$cat_database};
		@newdata = split(/\|:\|/,$line_vn);

		($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
		$newdata[0] = $temp_date;

		if ($newdata[0] ne $prevdate){
			$dailycount++;

			if (($dailycount > $Cnumonnews) && ($newsCount == 1)){
				last;
			}

			&getdate("$newdata[6]","$storyDate");	
		     
			if ($storyDate != 8){      
			  print FILE_VN "$beforeDateStory$returndate$afterDateStory\n\n";
			}

		}

		for($i=0; $i < 8; $i++){
		   	$storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
		}
		
		if ($cg_comment_system == 2){
			&getComment("$newdata[6]");
			$storybodytemp =~ s/(<<comments>>)/$more/;
		}
		if($cg_use_categories == 2){
			$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
		}

		print FILE_VN "$storybodytemp\n";

   $more = "";	
   $prevdate = $newdata[0];

}
close(FILE_VN);
}

##################

sub updateArchives {
	my $cat_database = $_[0];

	if ($cg_archivetype == 1) {
		&updateMonthlyNewsArchive("$cat_database");
	}
	if ($cg_archivetype == 2){
		&updateWeeklyNewsArchive("$cat_database");
	}
}

##################

sub updateMonthlyNewsArchive {
	my $cat_database = $_[0];

	my $beforeDateStory = $ct_beforeDateStory{$cat_database};
	my $afterDateStory = $ct_afterDateStory{$cat_database};
	my $Cnumonnews = $ct_numonnews{$cat_database};
	my $newsCount = $ct_newsCount{$cat_database};
	my $storyDate = $ct_storyDate{$cat_database};

	##
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
      	close(DIR);
	}
	push (@category_names, "");

	@data = @temp_data = @temp_data2 = ();
	open(DIR_N,"$datadir/$cat_database\.news");
     		@temp_data = <DIR_N>;
      close(DIR_N);

	foreach $allcategorylist (@cat_data){
		chomp($allcategorylist);                    
   		($cat_data_Id_a, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
		push (@category_names, $cat_data_Name);
		if($cat_data_Id_a == $cat_database){
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_a,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
	}

	foreach $line (@data) {
		@dataA = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$dataA[0]);
		$dataA[0] = $temp_date;

		($month,$day,$year) = split(/\//,$dataA[0]);
 
		$newmonth = "$month-$year";

		if ($newmonth ne $prevmonth){
			push (@monthsFiles, $newmonth);
		}
		$prevmonth = $newmonth;
	}

	$prevdate = 0;

	foreach $monthA (@monthsFiles) {

		open(AFILE,">$archivedir/($cat_database)$monthA\.archive");

		foreach $story (@data) {
			@newdata = split(/\|:\|/,$story);
			($temp_category_num, $temp_date2) = split(/\,/,$newdata[0]);
			$newdata[0] = $temp_date2;

			($monthA1,$dayA,$yearA) = split(/\//,$newdata[0]);
			$newmonthA = "$monthA1-$yearA";

			if ($newmonthA eq $monthA){	
     	   
			%hash = (
				0 => '<<date>>',
				1 => '<<author>>',
				2 => '<<email>>', 
				3 => '<<time>>',
				4 => '<<subject>>',
				5 => '<<byline>>',
				6 => '<<id>>',
				7 => '<<story>>',
			);
			$storybodytemp = $ct_storybody{$cat_database};

			if ($newdata[0] ne $prevdate){
				&getdate("$newdata[6]","$storyDate");

				if ($storyDate != 8){
				   print AFILE "$beforeDateStory$returndate$afterDateStory\n\n";
				}
			}

			for($i=0; $i < 8; $i++){
		   		$storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
			}
		
			if ($cg_comment_system == 2){
				&getComment("$newdata[6]");
				$storybodytemp =~ s/(<<comments>>)/$more/;
			}
			if($cg_use_categories == 2){
				$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
			}

		print AFILE "$storybodytemp\n";

	$more = "";
	$prevdate = $newdata[0];

	} #end if
	} #end foreach
	close(AFILE);
	}
}

####################################

sub updateWeeklyNewsArchive {
	my $cat_database = $_[0];

	my $beforeDateStory = $ct_beforeDateStory{$cat_database};
	my $afterDateStory = $ct_afterDateStory{$cat_database};
	my $Cnumonnews = $ct_numonnews{$cat_database};
	my $newsCount = $ct_newsCount{$cat_database};
	my $storyDate = $ct_storyDate{$cat_database};

	##
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
			@cat_data = <DIR>;
      	close(DIR);
	}
	push (@category_names, "");

	@data = @archiveNews = @temp_data = @temp_data2 = ();
	open(DIR_N,"$datadir/$cat_database\.news");
     		@temp_data = <DIR_N>;
      close(DIR_N);

	foreach $allcategorylist (@cat_data){
		chomp($allcategorylist);                    
   		($cat_data_Id_a, $cat_data_Name) = split(/\|:\|/,$allcategorylist);
		push (@category_names, $cat_data_Name);
		if($cat_data_Id_a == $cat_database){
			foreach $tmp_line (@temp_data){
				$tmp_line2 = "$cat_data_Id_a,$tmp_line";
				push (@temp_data2, $tmp_line2);
			}
			push (@data, @temp_data2);
		}
	}

	$dailycount = 0;
	$weeklydata = "";

	foreach $line (@data) {
		@dataA = split(/\|:\|/,$line);
		($temp_category_num, $temp_date) = split(/\,/,$dataA[0]);
		$dataA[0] = $temp_date;

		if ($dataA[0] ne $prevday){
			$dailycount++;
			if ($dailycount > 7){
				$dailycount = 1;
				push (@archiveNews, "$weeklydata\n");
				$weeklydata = "";
			}
			$weeklydata = "$weeklydata\:$dataA[0]";
		}
		$prevday = $dataA[0];
	}
	push (@archiveNews, "$weeklydata\n");

	$prevdate = 0;

	foreach $weeklyArchive (@archiveNews) {
		chop($weeklyArchive);
		@weekdata = ();
		@weekdata = split(/\:/,$weeklyArchive);

		($monthA1,$dayA1,$yearA1) = split(/\//,$weekdata[1]);
		$begin = "$monthA1\.$dayA1\.$yearA1";

		@newWeekdata = ();
		@newWeekdata = @weekdata;
		$end = pop(@newWeekdata);
		($monthA2,$dayA2,$yearA2) = split(/\//,$end);
		$end = "$monthA2\.$dayA2\.$yearA2";

		open(AFILE,">$archivedir/\($cat_database\)$end-$begin\.archive");

		foreach $story (@data) {
			@newdata = ();
			@newdata = split(/\|:\|/,$story);
			($temp_category_num, $temp_date) = split(/\,/,$newdata[0]);
			$newdata[0] = $temp_date;

	
			if (($newdata[0] eq "$weekdata[1]") || ($newdata[0] eq "$weekdata[2]") || 
			    ($newdata[0] eq "$weekdata[3]") || ($newdata[0] eq "$weekdata[4]") || 
			    ($newdata[0] eq "$weekdata[5]") || ($newdata[0] eq "$weekdata[6]") || 
			    ($newdata[0] eq "$weekdata[7]")){	
     	   
			%hash = (
				0 => '<<date>>',
				1 => '<<author>>',
				2 => '<<email>>', 
				3 => '<<time>>',
				4 => '<<subject>>',
				5 => '<<byline>>',
				6 => '<<id>>',
				7 => '<<story>>',
			);
			$storybodytemp = $ct_storybody{$cat_database};

			if ($newdata[0] ne $prevdate){
				&getdate("$newdata[6]","$storyDate");

				if ($storyDate != 8){
				   print AFILE "$beforeDateStory$returndate$afterDateStory\n\n";
				}
			}

			for($i=0; $i < 8; $i++){
				$storybodytemp =~ s/$hash{$i}/$newdata[$i]/;	
			}
		
			if ($cg_comment_system == 2){
				&getComment("$newdata[6]");
				$storybodytemp =~ s/(<<comments>>)/$more/;
			}
			if($cg_use_categories == 2){
				$storybodytemp =~ s/(<<category>>)/$category_names[$temp_category_num]/;
			}

		print AFILE "$storybodytemp\n";

   $more = "";
   $prevdate = $newdata[0];

} #end if
} #end foreach
close(AFILE);
}

}

####################################

sub error {
	$error = $_[0];

	&header;

	print "<center>\n";
	print "<table border=1 cellpadding=3 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#cecece\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";
	print "<center><strong>Error</strong></center><hr>\n";
	print "$error\n";

	&footer;
	exit(0);
}

###########################

sub setup_headlines {
	$category = $_[0];

	print "<table border=0 cellpadding=0 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#DDDDDD\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center><TABLE BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"100\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><center><font color=\"#FFFFFF\" size=\"3\" face=\"Arial\">Headline Options</font></strong></center></td></tr>\n";
	print "</table></center>\n";

	$beforeDateHeadline = $ct_beforeDateHeadline{$category};
	print "<ul>What HTML do you want before the date in the headlines\?<br>\n";
	print "<input size=20 name=\"beforeDateHeadline\" value=\"";
     if(! -e "$datadir/$category.conf"){
	print "<P><font face=\'arial\' color=\'#AF0000\' size=\'2\'>\">\n";
     }
     else{
	print "$beforeDateHeadline\">\n";
     }	
	print "<P>\n";

	$afterDateHeadline = $ct_afterDateHeadline{$category};
	print "What HTML do you want after the date in the headlines\?<br>\n";
	print "<input size=20 name=\"afterDateHeadline\" value=\"";
     if(! -e "$datadir/$category.conf"){
	print "</font><P>\">\n";
     }
     else{
	print "$afterDateHeadline\">\n";
     }
	print "<P>\n";

	$headlineDate = $ct_headlineDate{$category};
	print "What do you want the date to look like in the headlines\?<br>\n";
	print "(If you choose \'No Date\' the above to options will NOT show up on the web.)<br>\n";
	print "<select name=\"headlineDate\">\n";
	print "<option value=\"1\"";
     if (($headlineDate == 1) || (! -e "$datadir/$category.conf")){ print " selected"; }
	print ">Friday, January 1, 1999 (default)\n";
	print "<option value=\"2\"";
     if ($headlineDate == 2){ print " selected";}
	print ">FRIDAY, JANUARY 1, 1999\n";
	print "<option value=\"3\"";
     if ($headlineDate == 3){ print " selected";}
	print ">January 1, 1999\n";
	print "<option value=\"4\"";
     if ($headlineDate == 4){ print " selected";}
	print ">January 1st, 1999\n";
	print "<option value=\"5\"";
     if ($headlineDate == 5){ print " selected";}
	print ">Jan. 1, 1999\n";
	print "<option value=\"6\"";
     if ($headlineDate == 6){ print " selected";}
	print ">1-1-99\n";
	print "<option value=\"7\"";
     if ($headlineDate == 7){ print " selected";}
	print ">1/1/99\n";
	print "<option value=\"8\"";
     if ($headlineDate == 8){ print " selected";}
	print ">No Date\n";
	print "</select>\n";
	print "<P>\n";

	$numonheadlines = $ct_numonheadlines{$category};
	print "How many headlines do you want to be shown\?<BR>\n";
	print "<input size=3 name=\"numonheadlines\" maxlength=\"3\" value=\"";
     if(! -e "$datadir/$category.conf"){
	print "2\">\n";
     }
     else{
	print "$numonheadlines\">\n";
     }

	$headlineCount = $ct_headlineCount{$category};
	print "<select name=\"headlineCount\">\n";
	print "<option value=\"1\"";
     if (($headlineCount == 1) || (! -e "$datadir/$category.conf")){ print " selected";}
	print ">Days (default)\n";
	print "<option value=\"2\"";
     if ($headlineCount == 2){ print " selected";}
	print ">Stories\n";
	print "</select>\n";
	print "<P>\n";

	$headlinebody = $ct_headlinebody{$category};
	$headlinebody =~ s/\cM/\n/g;

	print "How do you want the headlines of the stories to look\?<br>\n";
	print "<strong>NOTE:</strong> Look in the readme file for specifics on how to edit this field. This field will change the look of all headlines of the news stories when they are shown on the web.<BR>\n";
	print "<textarea name=\"headlinebody\" rows=2 cols=60>\n";
     if(! -e "$datadir/$category.conf"){
	print "<LI><A HREF=\"http://your.address.here/index.html#<<id>>\"><FONT COLOR=\"#000000\" SIZE=\"-1\" FACE=\"arial\"><<subject>></FONT></A> - <A HREF=\"mailto:<<email>>\"><<author>></A> \@ <<time>> PST</FONT><BR>\n";
     }
     else{
	print "$headlinebody";
     }
	print "</textarea></ul><br>\n";
	print "</td></tr></table><P>\n";

}

############################

sub setup_news_story {
	$category = $_[0];

	print "<table border=0 cellpadding=0 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#DDDDDD\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center><TABLE BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"100\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><center><font color=\"#FFFFFF\" size=\"3\" face=\"Arial\">News Story Options</font></strong></center></td></tr>\n";
	print "</table></center>\n";

	$beforeDateStory = $ct_beforeDateStory{$category};
	print "<ul>What HTML do you want before the date on the news stories page\?<br>\n";
	print "<input size=20 name=\"beforeDateStory\" value=\"";
     if(! -e "$datadir/$category.conf"){
	print "<font face=\'arial\' color=\'#AF0000\' size=\'2\'>\">\n";
     }
     else{
	print "$beforeDateStory\">\n";
     }
	print "<P>\n";

	$afterDateStory = $ct_afterDateStory{$category};
	print "What HTML do you want after the date on the news stories page\?<br>\n";
	print "<input size=20 name=\"afterDateStory\" value=\"";
     if(! -e "$datadir/$category.conf"){
	print "</font><P>\">\n";
     }
     else{
	print "$afterDateStory\">\n";
     }
	print "<P>\n";

	$storyDate = $ct_storyDate{$category};
	print "What do you want the date to look like on the news stories page\?<br>\n";
	print "<select name=\"storyDate\">\n";
	print "<option value=\"1\"";
     if (($storyDate == 1) || (! -e "$datadir/$category.conf")){ print " selected"; }
	print ">Friday, January 1, 1999 (default)\n";
	print "<option value=\"2\"";
     if ($storyDate == 2){ print " selected";}
	print ">FRIDAY, JANUARY 1, 1999\n";
	print "<option value=\"3\"";
     if ($storyDate == 3){ print " selected";}
	print ">January 1, 1999\n";
	print "<option value=\"4\"";
     if ($storyDate == 4){ print " selected";}
	print ">January 1st, 1999\n";
	print "<option value=\"5\"";
     if ($storyDate == 5){ print " selected";}
	print ">Jan. 1, 1999\n";
	print "<option value=\"6\"";
     if ($storyDate == 6){ print " selected";}
	print ">1-1-99\n";
	print "<option value=\"7\"";
     if ($storyDate == 7){ print " selected";}
	print ">1/1/99\n";
	print "<option value=\"8\"";
     if ($storyDate == 8){ print " selected";}
	print ">No Date\n";
	print "</select>\n";
	print "<P>\n";

	$numonnews = $ct_numonnews{$category};
	print "How many days\/stories of news do you want to be shown on the main news page\?<BR>\n";
	print "<input size=3 name=\"numonnews\" maxlength=\"3\" value=\"";
     if(! -e "$datadir/$category.conf"){
	print "4\">\n";
     }
     else{
	print "$numonnews\">\n";
     }

	$newsCount = $ct_newsCount{$category};
	print "<select name=\"newsCount\">\n";
	print "<option value=\"1\"";
     if (($newsCount == 1) || (! -e "$datadir/$category.conf")){ print " selected";}
	print ">Days (default)\n";
	print "<option value=\"2\"";
     if ($newsCount == 2){ print " selected";}
	print ">Stories\n";
	print "</select>\n";
	print "<P>\n";

	$time = $ct_time{$category};
	print "How do you want the time to look\?<BR>\n";
	print "<select name=\"time\">\n";
	print "<option value=\"1\"";
     if (($time == 1) || (! -e "$datadir/$category.conf")){ print " selected";}
	print ">13:02 (default)\n";
	print "<option value=\"2\"";
     if ($time == 2){ print " selected";}
	print ">1:02 pm\n";
	print "</select>\n";
	print "<P>\n";

	$storybody = $ct_storybody{$category};
	$storybody =~ s/\cM/\n/g;

	print "How do you want the news stories to look\?<br>\n";
	print "<strong>NOTE:</strong> Look in the readme file for specifics on how to edit this field. This field will change the look of all news stories when they are shown on the web.<BR>\n";
	print "<textarea name=\"storybody\" rows=5 cols=60>\n";
     if(! -e "$datadir/$category.conf"){
	print "<B><A NAME=\"<<id>>\"><FONT COLOR=\"#00000\" SIZE=\"2\" FACE=\"arial\"><<subject>></FONT></B>\n";
	print "<FONT COLOR=\"#000000\" SIZE=\"2\" FACE=\"arial\"> - <A HREF=\"mailto:<<email>>\"><<author>></A> \@ <<time>> PST</FONT><br>\n";
	print "<FONT COLOR=\"#000000\" SIZE=\"2\" FACE=\"arial\"><<story>></FONT><P>\n";
     }
     else{
	print "$storybody";
     }
	print "</textarea></ul><br>\n";
	print "</td></tr></table><P>\n";

}

########################

sub save_individual_configuration {
	$category = $_[0];

	## HEADLINE INFORMATION ##
	$beforeDateHeadline = $FORM{'beforeDateHeadline'};
	$beforeDateHeadline =~ s/\|:\|//g;
	$beforeDateHeadline =~ s/"/'/g;

	$afterDateHeadline = $FORM{'afterDateHeadline'};
	$afterDateHeadline =~ s/\|:\|//g;
	$afterDateHeadline =~ s/"/'/g;

	$numonheadlines = $FORM{'numonheadlines'};
	$numonheadlines =~ s/\|:\|//g;
	$numonheadlines =~ s/"/'/g;

	$headlinebody = $FORM{'headlinebody'};
	$headlinebody =~ s/\n//g;
	$headlinebody =~ s/\|:\|//g;

	$headlineCount = $FORM{'headlineCount'};
	$headlineDate = $FORM{'headlineDate'};

	## STORY INFORMATION ##
	$beforeDateStory = $FORM{'beforeDateStory'};
	$beforeDateStory =~ s/\|:\|//g;
	$beforeDateStory =~ s/"/'/g;

	$afterDateStory = $FORM{'afterDateStory'};
	$afterDateStory =~ s/\|:\|//g;
	$afterDateStory =~ s/"/'/g;

	$numonnews = $FORM{'numonnews'};
	$numonnews =~ s/\|:\|//g;
	$numonnews =~ s/"/'/g;

	$storybody = $FORM{'storybody'};
	$storybody =~ s/\n//g;
	$storybody =~ s/\|:\|//g;

	$newsCount = $FORM{'newsCount'};
	$storyDate = $FORM{'storyDate'};
	$time = $FORM{'time'};

	######

	open (FILE,">$datadir/$category\.conf");
		flock(FILE, 2) unless (!$cgi_use_flock);
			## HEADLINE INFO ##
			print FILE "beforeDateHeadline|:|$beforeDateHeadline\n";
			print FILE "afterDateHeadline|:|$afterDateHeadline\n";
			print FILE "numonheadlines|:|$numonheadlines\n";
			print FILE "headlineCount|:|$headlineCount\n";
			print FILE "headlineDate|:|$headlineDate\n";
			print FILE "headlinebody|:|$headlinebody\n";

			## STORY INFO ##
			print FILE "beforeDateStory|:|$beforeDateStory\n";
			print FILE "afterDateStory|:|$afterDateStory\n";
			print FILE "numonnews|:|$numonnews\n";
			print FILE "newsCount|:|$newsCount\n";
			print FILE "storyDate|:|$storyDate\n";
			print FILE "time|:|$time\n";
			print FILE "storybody|:|$storybody\n";
		flock(FILE, 8) unless (!$cgi_use_flock);
      close(FILE);

}

##################  AUTOLINK CODE  ########################

sub autolinkOptions {
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Autolink Options");

	print "<center><strong>Autolink Options</strong></center><hr>\n";

	#####################
	# add new autolink

	print "<center><table border=0 cellpadding=1 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#DDDDDD\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center><TABLE BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"100\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><center><font color=\"#FFFFFF\" size=\"3\" face=\"Arial\">Add New Autolink</font></strong></center></td></tr>\n";
	print "</table></center>\n";
	
	print "<ul><FORM ACTION=\"$NewsScriptUrl\?addAutolink\" METHOD=\"post\">\n";
	print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
	print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
	print "<strong>Autolink Name:</strong>\n";
	print "<input type=text name=\"Aname\" SIZE=20>\n";

	print "<br><strong>Autolink URL:</strong>\n";
	print "<input type=text name=\"url\" SIZE=16>\n";
	
	print "<P><input type=\"submit\" value=\"Add Autolink\">\n";
	print "<input type=\"reset\" value=\"Reset\"></form></ul>\n";

	print "</td></tr>\n";
	print "</table>\n";
	print "</center>\n";  

	########################
	# edit or delete autolink
	
	open(FILE, "$datadir/autolinks.file");
      	@autolinkdata = <FILE>;
	close(FILE);

	print "<P><center><table border=0 cellpadding=1 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#DDDDDD\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center><TABLE BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"100\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><center><font color=\"#FFFFFF\" size=\"3\" face=\"Arial\">Edit/Delete Autolink</font></strong></center></td></tr>\n";
	print "</table></center>\n";
	
	print "<br><center><TABLE BORDER=\"1\" CELLSPACING=\"1\" CELLPADDING=\"1\" WIDTH=\"290\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Autolink Title</center></font></strong></td><td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Edit</center></font></strong></td>\n";
     if ($formAuthor eq "admin"){
	print "<td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Delete</center></font></strong></td>\n";
     }
	print "</tr>\n";

	foreach $item (@autolinkdata) {
		chop($item);                    
   		($name, $url) = split(/\|:\|/, $item);

		print "<tr><td><center>$name</center></td>\n";
		print "<td><center><FORM ACTION=\"$NewsScriptUrl\?editAutolink\" METHOD=\"POST\"><input type=\"hidden\" name=\"autolink\" value=\"$name\"><input type=\"hidden\" name=\"name\" value=\"$formAuthor\"><input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\"><input type=\"submit\" value=\"Edit\"></form></center></td>\n";
	     if ($formAuthor eq "admin"){	
		print "<td><center><FORM ACTION=\"$NewsScriptUrl\?deleteAutolink\" METHOD=\"POST\"><input type=\"hidden\" name=\"autolink\" value=\"$name\"><input type=\"hidden\" name=\"name\" value=\"$formAuthor\"><input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\"><input type=\"submit\" value=\"Delete\"></form></center></td>\n";
	     }
		print "</tr>\n";			
	}
	print "</center></TABLE><br>\n";

	print "</td></tr>\n";
	print "</table>\n";
	print "</center>\n";
	&footer;
}

############################

sub addAutolink {
	if ($FORM{'Aname'} eq ""){
		&error("Please go back and enter the AUTOLINK NAME field. All fields are required.");
	}
	elsif ($FORM{'url'} eq ""){
		&error("Please go back and enter the AUTOLINK URL field. All fields are required.");
	}
	else{
	
	$Aname = "$FORM{'Aname'}";
	$Aname =~ s/\|:\|//g;

	$url = "$FORM{'url'}";
	$url =~ s/\|:\|//g;

	&check_autolink_name("$Aname");

	$write = join("\|:\|",$Aname, $url);
	$write .= "\n";

	open (FILE,">>$datadir/autolinks.file");
		flock(FILE, 2) unless (!$cgi_use_flock);   	
   			print FILE "$write";	
		flock(FILE, 8) unless (!$cgi_use_flock);
      close(FILE);


	######################
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Autolink Options");

	print "<center><strong>New Autolink Added</strong></center><hr>\n";
	
	print "<strong>Autolink Name:</strong>\n";
	print "$Aname\n";
	print "<br><strong>Autolink URL:</strong>\n";
	print "$url<br><br>\n";

	&footer;
    }
}

###########################

sub editAutolink {
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Autolink Options");
	print "<center><strong>Edit Autolink</strong></center><hr>\n";

	$autolink = "$FORM{'autolink'}";

	open(FILE, "$datadir/autolinks.file");
      	@data = <FILE>;
	close(FILE);
	
	foreach $line (@data) {
		chop($line);                    
   		($name, $url) = split(/\|:\|/, $line);

		if ($autolink eq $name){
			print "<FORM ACTION=\"$NewsScriptUrl\?updateAutolink\" METHOD=\"post\">\n";
			print "<strong>Autolink Name:</strong>\n";
			print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
			print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
			print "<input type=text name=\"Aname\" SIZE=20 value=\"$name\">\n";
			print "<input type=hidden name=\"oldname\" value=\"$name\">\n";

			print "<br><strong>Autolink URL:</strong>\n";
			print "<input type=text name=\"url\" SIZE=20 value=\"$url\">\n";

			print "<P><input type=\"submit\" value=\"Edit Autolink\">\n";
			print "<input type=\"reset\" value=\"Reset\"></form>\n";
		}
	}
	&footer;
}

##########################

sub updateAutolink{
	if ($FORM{'Aname'} eq ""){
		&error("Please go back and enter the AUTOLINK NAME field. All fields are required.");
	}
	elsif ($FORM{'url'} eq ""){
		&error("Please go back and enter the AUTOLINK URL field. All fields are required.");
	}

	##
	$Aname = "$FORM{'Aname'}";
	$Aname =~ s/\|:\|//g;

	$oldname = "$FORM{'oldname'}";

	if ($Aname ne $oldname){
		&check_autolink_name("$Aname");
	}

	$url = "$FORM{'url'}";
	$url =~ s/\|:\|//g;

				
	open(READ, "$datadir/autolinks.file");
      	flock(READ, 2) unless (!$cgi_use_flock);
			@data = <READ>;
		flock(READ, 8) unless (!$cgi_use_flock);
	close(READ);
			
	open(WRITE,">$datadir/autolinks.file");
  		flock(WRITE, 2) unless (!$cgi_use_flock);
   
		foreach $line (@data) {
			chop($line);                    

   			($nameF, $urlF) = split(/\|:\|/, $line);
				if ($oldname eq $nameF){
					$write = join("\|:\|",$Aname, $url);
					$write .= "\n";
					print WRITE "$write";
				}
				else {
					print WRITE "$line\n";
				}
		} # end foreach

		flock(WRITE, 8) unless (!$cgi_use_flock);
	close(WRITE);
	
	######################
	$formAuthor = "$FORM{'name'}";

	&header;
	&menu("$formAuthor","$FORM{'password'}","Autolink Options");

	print "<center><strong>Autolink Edited</strong></center><hr>\n";
		
	print "<strong>Autolink Name:</strong>\n";
	print "$Aname\n";
	print "<br><strong>Autolink URL:</strong>\n";
	print "$url<br><br>\n";

	&footer;	
}

######################

sub deleteAutolink {
	$formAuthor = "$FORM{'name'}";

	&header;
	&menu("$formAuthor","$FORM{'password'}","Autolink Options");

	print "<center><strong>Delete Autolink</strong></center><hr>\n";

	$autolink = "$FORM{'autolink'}";

	open(FILE, "$datadir/autolinks.file");
      	@data = <FILE>;
	close(FILE);

	foreach $line (@data) {
		chop($line);                    
   		($name, $url) = split(/\|:\|/, $line);

		if ($autolink eq $name){
		
			print "<FORM ACTION=\"$NewsScriptUrl\?delAutolink\" METHOD=\"post\">\n";
			print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
			print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";

			print "<strong>Are you sure you want to delete this autolink?</strong>\n";

			print "<P><strong>Autolink Name:</strong>\n";
			print "<input type=hidden name=\"Aname\" value=\"$name\"> $name\n";
			print "<br><strong>Autolink URL:</strong>\n";
			print " $url\n";

			print "<P><input type=\"submit\" value=\"Delete Autolink\">\n";
			print "</form>\n";

		}
	}
			&footer;
}

###########################

sub delAutolink{

	$Aname = "$FORM{'Aname'}";
				
	open(READ, "$datadir/autolinks.file");
     		flock(READ, 2) unless (!$cgi_use_flock);   
			@data = <READ>;
		flock(READ, 8) unless (!$cgi_use_flock);
	close(READ);
			
	open(WRITE,">$datadir/autolinks.file");
  		flock(WRITE, 2) unless (!$cgi_use_flock);
   
	foreach $line (@data) {
		chop($line);                    

   		($nameF, $urlF) = split(/\|:\|/, $line);
			if ($Aname eq $nameF){
				$Nurl = $urlF;
			}
			else {
				print WRITE "$line\n";
			}
	} # end foreach

		flock(WRITE, 8) unless (!$cgi_use_flock);
	close(WRITE);
	
	######################
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Autolink Options");

	print "<center><strong>Autolink Deleted</strong></center><hr>\n";
		
	print "<strong>The following autolink has been deleted.</strong><P>\n";
	print "<strong>Autolink Name:</strong>\n";
	print "$Aname<br>\n";

	print "<strong>Autolink URL:</strong>\n";
	print "$Nurl<br><br>\n";

	&footer;		
}

#########################################

sub viewAutolinks {
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}");

	print "<center><strong>View Autolinks</strong></center><hr>\n";

	print "<center>\n";
	print "<TABLE BORDER=\"1\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"99\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Autolink Name</center></font></strong></td><td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Autolink URL</center></font></strong></td></tr>\n";

	open(DIR,"$datadir/autolinks.file");
     	  @data = <DIR>;
      close(DIR);
	@data = sort (@data);

	foreach $line (@data) {
		chop($line);                    
   		($name, $url) = split(/\|:\|/, $line);

		print "<tr><td><center>$name</center></td><td><center><a href=\"$url\">$url</a></center></td></tr>\n";
	}
	print "</TABLE>\n";
	&footer;
}

##################  CATEGORIES CODE  ########################

sub categoryOptions {
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");

	print "<center><strong>Category Options</strong></center><hr>\n";

	#####################
	# create new category

	print "<center><table border=0 cellpadding=1 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#DDDDDD\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center><TABLE BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"100\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><center><font color=\"#FFFFFF\" size=\"3\" face=\"Arial\">Create New Category</font></strong></center></td></tr>\n";
	print "</table></center>\n";
	
	print "<ul><FORM ACTION=\"$NewsScriptUrl\?createCategory\" METHOD=\"post\">\n";
	print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
	print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
	print "<strong>Category Name:</strong>\n";
	print "<input type=text name=\"Catname\" SIZE=20>\n";

	print "<P><input type=\"submit\" value=\"Create Category\">\n";
	print "<input type=\"reset\" value=\"Reset\"></form></ul>\n";

	print "</td></tr>\n";
	print "</table>\n";
	print "</center>\n";  

	########################
	# edit or delete category
	
	open(FILE, "$datadir/categories.file");
      	@catdata = <FILE>;
	close(FILE);

	print "<P><center><table border=0 cellpadding=1 cellspacing=1 width=100\%>\n";
	print "<tr bgcolor=\"#DDDDDD\">\n";
	print "<td colspan=1 rowspan=1 valign=top align=left>\n";

	print "<center><TABLE BORDER=\"0\" CELLSPACING=\"1\" CELLPADDING=\"1\" width=\"100\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><center><font color=\"#FFFFFF\" size=\"3\" face=\"Arial\">Edit/Delete Category</font></strong></center></td></tr>\n";
	print "</table></center>\n";
	
	print "<br><center><TABLE BORDER=\"1\" CELLSPACING=\"1\" CELLPADDING=\"1\" WIDTH=\"50\%\">\n";
	print "<tr bgcolor=\"#800000\"><td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Category Name</center></font></strong></td>\n";
	print "<td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Category ID\#</center></font></strong></td>\n";
	print "<td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Edit</center></font></strong></td>\n";
	print "<td><strong><font color=\"#FFFFFF\" size=\"2\" face=\"Arial\"><center>Delete</center></font></strong></td>\n";

	print "</tr>\n";

	if($cg_special_category == 2){
		print "<tr>\n";
		print "<td><center>Special Category</center></td>\n";
		print "<td><center>N/A</center></td>\n";
		print "<td><center><FORM ACTION=\"$NewsScriptUrl\?editCategory\" METHOD=\"POST\"><input type=\"hidden\" name=\"categoryID\" value=\"all\"><input type=\"hidden\" name=\"name\" value=\"$formAuthor\"><input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\"><input type=\"submit\" value=\"Edit\"></form></center></td>\n";
		print "<td><center>N/A</center></td>\n";	
		print "</tr>\n";			
	}

	foreach $item (@catdata) {
		chop($item);                    
   		($cat_num, $cat_name) = split(/\|:\|/,$item);

		print "<tr>\n";
		print "<td><center>$cat_name</center></td>\n";
		print "<td><center>$cat_num</center></td>\n";
		print "<td><center><FORM ACTION=\"$NewsScriptUrl\?editCategory\" METHOD=\"POST\"><input type=\"hidden\" name=\"categoryID\" value=\"$cat_num\"><input type=\"hidden\" name=\"name\" value=\"$formAuthor\"><input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\"><input type=\"submit\" value=\"Edit\"></form></center></td>\n";
		if($cat_num == 1){
			print "<td><center>N/A</center></td>\n";
		}
		else {
			print "<td><center><FORM ACTION=\"$NewsScriptUrl\?deleteCategory\" METHOD=\"POST\"><input type=\"hidden\" name=\"categoryID\" value=\"$cat_num\"><input type=\"hidden\" name=\"name\" value=\"$formAuthor\"><input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\"><input type=\"submit\" value=\"Delete\"></form></center></td>\n";
		}
		print "</tr>\n";			
	}
	print "</center></TABLE><br>\n";

	print "</td></tr>\n";
	print "</table>\n";
	print "</center>\n";
	&footer;
}

######################

sub create_category {
	if ($FORM{'Catname'} eq ""){
		&error("Please go back and enter a name in the CATEGORY NAME field.");
	}

	$Catname = "$FORM{'Catname'}";
	$Catname =~ s/\|:\|//g;
	$Catname =~ s/\"//g;
	$Catname =~ s/\'//g;

	$category_idNum = &get_previous_cat_num;

	open(FILE,">>$datadir/categories.file");
   		print FILE "$category_idNum|:|$Catname\n";
   	close(FILE);

	######################
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");

	print "<center><strong>New Category Added</strong></center><hr>\n";
	
	print "<strong>Category Name:</strong>\n";
	print "$Catname\n";
	print "<br><strong>Category ID:</strong>\n";
	print "$category_idNum<br><br>\n";

	print "<hr>\n";
	print "<center>Please continue the configuration below.</center>\n";
	print "<hr>\n";
	print "<FORM ACTION=\"$NewsScriptUrl\?setCategoryConf\" METHOD=\"POST\">\n";
	print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
	print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";

	&setup_headlines("$category_idNum");
	&setup_news_story("$category_idNum");

	print "<input type=\"hidden\" name=\"categoryID\" value=\"$category_idNum\">\n";

	print "<center><input type=\"submit\" name=\"configure\" value=\"Set Configuration\">\n";
	print "<input type=\"reset\" value=\"Reset\"><center></form>\n";

	&footer;
}

######################

sub get_previous_cat_num {
	@allIds = ();

	if(-e "$datadir/categories.file"){
   		open(FILE,"$datadir/categories.file");
   			@file = <FILE>;
   		close(FILE);

		foreach $category_number (@file){
			chop($category_number);
			($temp_cat_num, $temp_cat_name) = split(/\|:\|/,$category_number);
			push (@allIds, $temp_cat_num);
   		}

		@tempIds = (sort { $a <=> $b } @allIds);
		$next_cat_num = pop(@tempIds);
		$next_cat_num++;
	}
	else {
	   	open(FILE,">$datadir/categories.file");
   			print FILE "1|:|Default\n";
   		close(FILE);	

		$next_cat_num = 2;
	}

	return $next_cat_num;
}

###################

sub setup_category {
	if (($FORM{'beforeDateHeadline'} eq "") || ($FORM{'afterDateHeadline'} eq "") || ($FORM{'numonheadlines'} eq "") || ($FORM{'headlinebody'} eq "")){
		&error("Please go back and fill in all the fields in the Headline Options section. All fields are required.");
	}
	elsif (($FORM{'beforeDateStory'} eq "") || ($FORM{'afterDateStory'} eq "") || ($FORM{'numonnews'} eq "") || ($FORM{'storybody'} eq "")){
		&error("Please go back and fill in all the fields in the News Story Options section. All fields are required.");
	}
	$categoryID = $FORM{'categoryID'};

	&save_individual_configuration("$categoryID");

	##################
	$formAuthor = $FORM{'name'};
	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");

	print "<center><strong>Category Options</strong></center><hr>\n";
	print "<center>\n";
	print "Your configuration has been set for this category. It may be changed at any time.\n";
	print "</center><br>\n";
	&footer;
}

#####################

sub editCategory {
	$formAuthor = $FORM{'name'};

	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");
	print "<center><strong>Edit Category</strong></center><hr>\n";

	$categoryID = "$FORM{'categoryID'}";

	open(FILE, "$datadir/categories.file");
      	@data = <FILE>;
	close(FILE);

	print "To edit the category\'s configuration, click on the \"Edit Category\" button.\n";
	if ($categoryID eq "all"){
		print "Click the button below to continue the configuration of the Special Category.\n";
		print "<FORM ACTION=\"$NewsScriptUrl\?updateCategory\" METHOD=\"post\">\n";
		print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
		print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
		print "<strong>Category Name:</strong> Special Category\n";
		print "<input type=hidden name=\"Catname\" value=\"Special Category\">\n";
		print "<input type=hidden name=\"Catnum\" value=\"all\">\n";
		print "<P><input type=\"submit\" value=\"Edit Category\">\n";
		print "</form>\n";

	}
	else {
		print "If you are wanting to edit the category\'s name, do that below before going on\n"; 
		print "to edit the configuration.\n";
	}

	foreach $line (@data) {
		chop($line);
		($tmp_cat_num, $tmp_cat_name) = split(/\|:\|/,$line);                    

		if ("$categoryID" == "$tmp_cat_num"){
			print "<FORM ACTION=\"$NewsScriptUrl\?updateCategory\" METHOD=\"post\">\n";
			print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
			print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";

			print "<strong>Category Name:</strong>\n";
			print "<input type=text name=\"Catname\" value=\"$tmp_cat_name\" size=\"20\">\n";
			print "<input type=hidden name=\"Catnum\" value=\"$tmp_cat_num\">\n";
			print "<P><input type=\"submit\" value=\"Edit Category\">\n";
			print "<input type=\"reset\" value=\"Reset\"></form>\n";
		}
	}
	&footer;
}

###################

sub updateCategory {
	if ($FORM{'Catname'} eq ""){
		&error("Please go back and enter the name in the CATEGORY NAME field.");
	}

	$Catname = "$FORM{'Catname'}";
	$Catname =~ s/\|:\|//g;
	$Catname =~ s/\"//g;
	$Catname =~ s/\'//g;

	$Catnum = "$FORM{'Catnum'}";

     if ($Catnum ne "all"){
	open(FILE, "$datadir/categories.file");
      	@data = <FILE>;
	close(FILE);

	open(WRITE,">$datadir/categories.file");
  		flock(WRITE, 2) unless (!$cgi_use_flock);

		foreach $line (@data) {
			chop($line);
			($tmp_cat_num, $tmp_cat_name) = split(/\|:\|/,$line);                    

			if ("$Catnum" == "$tmp_cat_num"){
				$write = join("\|:\|",$tmp_cat_num, $Catname);
				$write .= "\n";
				print WRITE "$write";
			}
			else {
				print WRITE "$line\n";
			}
		}
		flock(WRITE, 8) unless (!$cgi_use_flock);
	close(WRITE);
     }

	######################
	$formAuthor = "$FORM{'name'}";
		
	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");

	print "<center><strong>Category Edited</strong></center><hr>\n";
	
	print "<strong>Category Name:</strong>\n";
	print "$Catname\n";
	print "<br><strong>Category ID:</strong>\n";
	print "$Catnum<br><br>\n";

	print "<hr>\n";
	print "<center>Please continue the configuration below.</center>\n";
	print "<hr>\n";
	print "<FORM ACTION=\"$NewsScriptUrl\?setCategoryConf\" METHOD=\"POST\">\n";
	print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
	print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";

	&setup_headlines("$Catnum");
	&setup_news_story("$Catnum");

	print "<input type=\"hidden\" name=\"categoryID\" value=\"$Catnum\">\n";

	print "<center><input type=\"submit\" name=\"configure\" value=\"Set Configuration\">\n";
	print "<input type=\"reset\" value=\"Reset\"><center></form>\n";

	&footer;	

}

#####################

sub deleteCategory {
	$formAuthor = "$FORM{'name'}";

	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");

	print "<center><strong>Delete Category</strong></center><hr>\n";

	$categoryID = "$FORM{'categoryID'}";

	open(FILE, "$datadir/categories.file");
      	@data = <FILE>;
	close(FILE);

	print "Are you sure you want to delete this category?<br>\n";
	print "<strong>NOTE:</strong> When deleting a category, all of the categories news and settings are also deleted.\n";

	foreach $line (@data) {
		chop($line);
		($tmp_cat_num, $tmp_cat_name) = split(/\|:\|/,$line);                    

		if ("$categoryID" == "$tmp_cat_num"){
			print "<FORM ACTION=\"$NewsScriptUrl\?delCategory\" METHOD=\"post\">\n";
			print "<input type=\"hidden\" name=\"name\" value=\"$formAuthor\">\n";
			print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";

			print "<strong>Category Name:</strong>\n";
			print "$tmp_cat_name\n";
			print "<br>\n";
			print "<strong>Category ID\#:</strong>\n";
			print "$tmp_cat_num\n";
			print "<input type=hidden name=\"Catnum\" value=\"$tmp_cat_num\">\n";
			print "<P><input type=\"submit\" value=\"Delete Category\">\n";
			print "</form>\n";
		}
	}
	&footer;
}

####################

sub delCategory {
	$Catnum = "$FORM{'Catnum'}";

	open(FILE, "$datadir/categories.file");
      	@data = <FILE>;
	close(FILE);

	## Remove from categories file ##

	open(WRITE,">$datadir/categories.file");
  		flock(WRITE, 2) unless (!$cgi_use_flock);

		foreach $line (@data) {
			chop($line);
			($tmp_cat_num, $tmp_cat_name) = split(/\|:\|/,$line);                    

			if ("$Catnum" == "$tmp_cat_num"){
				$Catname = $tmp_cat_name;
				# delete category
			}
			else {
				print WRITE "$line\n";
			}
		}
		flock(WRITE, 8) unless (!$cgi_use_flock);
	close(WRITE);

	## Delete configuration ##
	unlink("$datadir/$Catnum\.conf");

	## Delete news file ##
	unlink("$datadir/$Catnum\.news");

	## Delete view news file ##
	unlink("$datadir/$Catnum\.viewn");

	## Delete view headlines file ##
	unlink("$datadir/$Catnum\.viewh");

	## Renumber all other categories ##
	&reNumberCats("$Catnum");

	######################
	$formAuthor = "$FORM{'name'}";
		
	&header;
	&menu("$formAuthor","$FORM{'password'}","Category Options");

	print "<center><strong>Category Deleted</strong></center><hr>\n";
	
	print "<strong>Category Name:</strong>\n";
	print "$Catname\n";
	print "<br><strong>Category ID:</strong>\n";
	print "$Catnum<p>\n";

	print "The category has been deleted. And the files have been updated.<p>\n";

	print "<strong>NOTE:</strong> When the files are updated, the file names change.\n";
	print "(eg. If you had three categories \[1,2,3\] and deleted 2, then category 3,\n";
	print "has now changed to be category 2.) Please update all your SSI calls to reflect\n";
	print "this change.\n";

	&footer;
}

###################

sub reNumberCats {
	$CatDeleted = $_[0];

	open(FILE, "$datadir/categories.file");
      	@data = <FILE>;
	close(FILE);

	## Renumber all categories ##

	$renumberedCat = 0;

	open(WRITE,">$datadir/categories.file");
  		flock(WRITE, 2) unless (!$cgi_use_flock);
		foreach $line (@data) {
			chop($line);
			($tmp_cat_num, $tmp_cat_name) = split(/\|:\|/,$line); 
				$renumberedCat++;
				$write = join("\|:\|",$renumberedCat, $tmp_cat_name);
				$write .= "\n";
				print WRITE "$write";

				&reNameCats("$tmp_cat_num","$renumberedCat");
		}
		flock(WRITE, 8) unless (!$cgi_use_flock);
	close(WRITE);

}

####################

sub reNameCats {
	$originalCatnum = $_[0];
	$newCatnum = $_[1];

 	## FORMAT:  rename OLDNAME,NEWNAME
	## Rename configuration ##
	rename ("$datadir/$originalCatnum\.conf", "$datadir/$newCatnum\.conf");

	## Rename news file ##
	rename ("$datadir/$originalCatnum\.news", "$datadir/$newCatnum\.news");

	## Rename view news file ##
	rename ("$datadir/$originalCatnum\.viewn", "$datadir/$newCatnum\.viewn");

	## Rename view headlines file ##
	rename ("$datadir/$originalCatnum\.viewh", "$datadir/$newCatnum\.viewh");

}

##################    COMMENTS SCRIPT CODE    ####################

sub comments {
	$id = $_[0];
	$authorA = $_[1];
	$emailA = $_[2];
	$subjectA = $_[3];
	$storyA = $_[4];

	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);

   	if ($min < 10) { $min = "0$min"; }
   	if ($hour < 10) { $hour = "0$hour"; }
	if ($sec < 10) { $sec = "0$sec"; }	
   	if ($mday < 10) { $mday = "0$mday"; }
	if ($mon < 10) { $mon = "0$mon"; }

   	$month = ($mon + 1);

	$real_year = $year % 100;
	$real_year = "0$real_year" if($real_year < 10);
	$date = "$month/$mday/$real_year";
	$time = "$hour\:$min\:$sec";

	$name = "$authorA";
	$name =~ s/\|//g;
	$name = "<font color=$admin_color>$name</font>";

	$subject = "$subjectA";
	$subject =~ s/\|//g;
		
	$email = "$emailA";
	$email =~ s/\|//g;

	$comments = "$storyA";
	$comments =~ s/\cM//g;
	$comments =~ s/\n/<br>/g;
	$comments =~ s/\n\n/<p>/g;
      
	$comments =~ s/\|//g;

	$followup = "";
	$ip = $ENV{'REMOTE_ADDR'};

	&get_number;

	$writeC = join("\|",$num, $name, $email, $subject, $followup,"", $date, $time, $ip, $comments);
	$writeC .= "\n";
	open (FILE,">>$commentsdir/comments.txt");
		flock(FILE, 2) unless (!$cgi_use_flock);   	
   			print FILE "$writeC";	
		flock(FILE, 8) unless (!$cgi_use_flock);
      close(FILE);

	$writeD = join("\|",$id, $num, "0");
	$writeD .= "\n";
	open (FILE1,">>$commentsdir/data.txt");
		flock(FILE1, 2) unless (!$cgi_use_flock);   	
   			print FILE1 "$writeD";	
		flock(FILE1, 8) unless (!$cgi_use_flock);
      close(FILE1);
}

##################

sub get_number {
   open(NUMBER,"$commentsdir/count.txt");
   	$num = <NUMBER>;
   close(NUMBER);

   if(! -e "$commentsdir/count.txt") {
	$num = "1";
   }
   elsif ($num == 99999)  {
      $num = "1";
   }
   else {
      $num++;
   }
   open(NUM,">$commentsdir/count.txt") || die $!;
   	print NUM "$num";
   close(NUM);
}

##########################

sub getComment {
	$commentID = $_[0];

	open(FILE_CID, "$commentsdir/data.txt");
      	@comments_i = <FILE_CID>;
	close(FILE_CID);

	foreach $data_cm (@comments_i) {
		chop($data_cm);                    
		($id_d, $msg_num, $replies) = split(/\|/, $data_cm);

		if ("$id_d" eq "$commentID") {
			$more = "<a href=\"$CommentsScriptUrl\?view=$msg_num\">$title \($replies\)<\/a>";
		}
	}
}

##
1;