#!/usr/local/bin/perl

#######################################################################
#							                            # 
#                          News Publisher                             #
#                              Upgrade  	                            #
#		   	          Version 1.01                              #
# 	                                                                #
#                    Created by Grant Williams                        # 
#					                                        #
# Created on:  8/16/99          Last Modified on:  8/16/99            #
# I can be reached at:          gcw07@ionet.net                       #
# Scripts Found at:             http://www.roosh.com/news_publisher/  #
#######################################################################
# Please use the forum at the site for support questions and not      #
# email them. The forum is checked often.				          #
#######################################################################
# COPYRIGHT NOTICE:								    #
# 										          #
# Copyright 1999 Grant Williams    All Rights Reserved.               #
#											    #
# This program may be used and modified free of charge by anyone, as  #
# long as this copyright notice and the header above remain intact.   #  
# By using this program you agree to indemnify Grant Williams from    #
# any liability that might arise from it's use.                       #
#											    #
# Selling the code for this program without prior written consent is  #
# expressly forbidden. Obtain permission before redistributing this   #
# software over the Internet or in any other medium.  In all cases    #
# copyright and header must remain intact.                            #
#                                                                     #
#######################################################################
# Define Variables

require "config.cgi";
$UpgradeScriptUrl = "upgrade.cgi";

##########################################################################
# 												 #
#    DO NOT EDIT BELOW THIS LINE							 #
#												 #
##########################################################################
&parse_form_now;

if ($FORM{'upgrade4'}){
	&upgrade4;
}
elsif ($FORM{'upgrade5'}){
	&upgrade5;
}
else {
	&start;
}


sub start {
	print "Content-Type: text/html\n\n";
	print "Click below to upgrade to version 1.06. This program will upgrade your data files to the current format.\n";
	print "Make sure you read the upgrade readme before running this program.<br><b>If upgrade is successful do NOT run this again.</b>\n";
	print "<b>If you run it again, it can corrupt your news.</b><br> Remember to always backup your news files (eg. 1.news, 2.news, etc.) before running this.<P>\n";
	
	if(-e "$datadir/news.txt") {
		print "<FORM ACTION=\"$UpgradeScriptUrl\" METHOD=\"POST\">\n";
		print "<INPUT TYPE=\"submit\" name=\"upgrade4\" value=\"Begin Upgrade Now!\">\n";
		print "</FORM>\n";
	}
	else {
		print "<FORM ACTION=\"$UpgradeScriptUrl\" METHOD=\"POST\">\n";
		print "<INPUT TYPE=\"submit\" name=\"upgrade5\" value=\"Upgrade Now!\">\n";
		print "</FORM>\n";
	}
}

sub upgrade4 {

	## UPDATE AUTHORS ##

	open(FILE,"$datadir/authors.txt");
      	@authors_data = <FILE>;
	close(FILE);
	
	open(WRITE,">$datadir/authors.file");
	foreach $line (@authors_data) {
		chop($line);
   		($name, $email, $password, $level) = split(/\|/,$line);
		$write = join("\|",$name, $email, $password, $level, "1,");
		$write .= "\n";
		print WRITE "$write";
	}
	close(WRITE);

	unlink("$datadir/authors.txt");

	## UPDATE AUTHORS ##

########################################

	## UPDATE AUTOLINKS ##

	open(FILE,"$datadir/autolink.txt");
      	@autolink_data = <FILE>;
	close(FILE);
	
	open(WRITE,">$datadir/autolinks.file");
	foreach $line (@autolink_data) {
		chop($line);
   		($auto_name, $auto_link) = split(/\|/,$line);
		$write = join("\|:\|",$auto_name,$auto_link);
		$write .= "\n";
		print WRITE "$write";
	}
	close(WRITE);

	unlink("$datadir/autolink.txt");

	## UPDATE AUTOLINKS ##

########################################

	## UPDATE NEWS FILE ##

	open(FILE,"$datadir/news.txt");
      	@news_data = <FILE>;
	close(FILE);
	
	open(DIR,">$datadir/1.news");
		print DIR (@news_data);
	close(DIR);

	unlink("$datadir/news.txt");

	## UPDATE NEWS FILE ##

########################################

	## UPDATE CONFIG FILE ##

	open(FILE,"$datadir/config.txt");
      	@config_data = <FILE>;
	close(FILE);

	foreach $line (@config_data) {
		chop($line);                    
   		($cname, $cvalue) = split(/::/,$line);
		$CONF{$cname} = $cvalue;	
	}

	open(WRITE,">$datadir/NP.setup");
		print WRITE "authoredit|:|$CONF{'authoredit'}\n";
		print WRITE "encryption|:|$CONF{'encryption'}\n";
		print WRITE "archivetype|:|$CONF{'archivetype'}\n";
		print WRITE "comment_system|:|$CONF{'comment_system'}\n";
		print WRITE "use_categories|:|1\n";
		print WRITE "special_category|:|1\n";
		print WRITE "oldmessages|:|$CONF{'oldmessages'}\n";
		print WRITE "timeoffset|:|$CONF{'timeoffset'}\n";
		print WRITE "htmlSource|:|$CONF{'htmlSource'}\n";
	close(WRITE);

	open(WRITE,">$datadir/1.conf");
		print WRITE "beforeDateHeadline|:|$CONF{'beforeDateHeadline'}\n";
		print WRITE "afterDateHeadline|:|$CONF{'afterDateHeadline'}\n";
		print WRITE "numonheadlines|:|$CONF{'numonheadlines'}\n";
		print WRITE "headlineCount|:|$CONF{'headlineCount'}\n";
		print WRITE "headlineDate|:|$CONF{'headlineDate'}\n";
		print WRITE "headlinebody|:|$CONF{'headlinebody'}\n";
		print WRITE "beforeDateStory|:|$CONF{'beforeDateStory'}\n";
		print WRITE "afterDateStory|:|$CONF{'afterDateStory'}\n";
		print WRITE "numonnews|:|$CONF{'numonnews'}\n";
		print WRITE "newsCount|:|$CONF{'newsCount'}\n";
		print WRITE "storyDate|:|$CONF{'storyDate'}\n";
		print WRITE "time|:|$CONF{'time'}\n";
		print WRITE "storybody|:|$CONF{'storybody'}\n";
	close(WRITE);

	unlink("$datadir/config.txt");

	## UPDATE CONFIG FILE ##

#############################################

	print "Content-Type: text/html\n\n";
	print "Your information has been updated to work with version 1.05. To finish the upgrade to 1.06 click below.<p>\n";

	print "Be sure you update your SSI calls to the new names.\n";
	print "To find the new names, look in the upgrade readme file. Also make sure to delete the old viewnews.txt and viewheadlines.txt files,\n";
	print "since the new names are now, 1.viewn and 1.viewh, respectively.\n";

	print "<FORM ACTION=\"$UpgradeScriptUrl\" METHOD=\"POST\">\n";
	print "<INPUT TYPE=\"submit\" name=\"upgrade5\" value=\"Continue Upgrading Now!\">\n";
	print "</FORM>\n";

}

sub upgrade5 {
	@cat_data = ();
	if(! -e "$datadir/categories.file"){
		push (@cat_data, "1|:|Default\n");
	}
	else {
		open(DIR,"$datadir/categories.file");
  			@cat_data = <DIR>;
      	close(DIR);
	}

	foreach $cat_data_line (@cat_data){
		chomp($cat_data_line);                    
   		($cat_data_Id_1, $cat_data_Name) = split(/\|:\|/,$cat_data_line);

		open(FILE,"$datadir/$cat_data_Id_1\.news");
      		@news_data = <FILE>;
		close(FILE);

		open(WRITE,">$datadir/$cat_data_Id_1\.news");
			foreach $line (@news_data) {
				chop($line);
   				($date, $author, $email, $texttime, $subject, $id, $story) = split(/\|/,$line);
				$write = join("\|:\|",$date, $author, $email, $texttime, $subject, "", $id, $story);
				$write .= "\n";
				print WRITE "$write";
			}
		close(WRITE);
	}

#############################################

	print "Content-Type: text/html\n\n";
	print "<center><b>UPGRADE WAS SUCCESSFUL</b></center>\n";
	print "Your information has been updated to work with version 1.06.<p>\n";

	print "The following is for people upgrading from 1.04a and below. If you are upgrading from 1.05 and above, you can ignore it.<p>\n";
	print "If you haven\'t already done this, do the following:<br>\n";
	print "Be sure you update your SSI calls to the new names.\n";
	print "To find the new names, look in the upgrade readme file. Also make sure to delete the old viewnews.txt and viewheadlines.txt files,\n";
	print "since the new names are now, 1.viewn and 1.viewh, respectively.\n";

}

sub parse_form_now {
	read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
      @pairs = split(/&/, $buffer);

      foreach $pair (@pairs) {
       	($name, $value) = split(/=/, $pair);
		$value =~ tr/+/ /;
          	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
          	$value =~ s/<!--(.|\n)*-->//g;

          	$FORM{$name} = $value;
       }
}
